; ============================================================================================================================
; File		: Curl.au3 (2015.06.04)
; Purpose	: AutoIt binary code version of libcurl with SSL support
; Author	: Ward
; Dependency: BinaryCall.au3

; Source	: libcurl 7.42.1
; Author	: Copyright (C) 1997 - 2015 by Daniel Stenberg.
; Website	: http://curl.haxx.se/

; Source	: mbed TLS/PolarSSL
; Author	: Copyright (C) 2006-2014, ARM Limited
; Website	: https://tls.mbed.org/
; ============================================================================================================================

; ============================================================================================================================
; Public Functions:
;   Curl_Escape($String, $Encode = 1)
;   Curl_Unescape($String, $Encode = 1)
;   Curl_FormAdd(ByRef $FirstItem, ByRef $LastItem, $Option1, $Value1, $Option2, $Value2 = 0, $Option3 = 0, $Value3 = 0, $Option4 = 0, $Value4 = 0, $Option5 = 0, $Value5 = 0, $Option6 = 0, $Value6 = 0, $Option7 = 0, $Value7 = 0, $Option8 = 0, $Value8 = 0, $Option9 = 0, $Value9 = 0, $Option10 = 0, $Value10 = 0, $Option11 = 0, $Value11 = 0, $Option12 = 0, $Value12 = 0, $Option13 = 0, $Value13 = 0, $Option14 = 0, $Value14 = 0, $Option15 = 0, $Value15 = 0, $Option16 = 0, $Value16 = 0, $Option17 = 0, $Value17 = 0, $Option18 = 0, $Value18 = 0, $Option19 = 0, $Value19 = 0, $Option20 = 0, $Value20 = 0)
;   Curl_FormFree($FirstItem)
;   Curl_Free($Ptr)
;   Curl_GetDate($DateString, $Now = 0)
;   Curl_Global_Cleanup($Flag)
;   Curl_Global_Init($Flag)
;   Curl_Global_Init_Mem($Flag, $MallocCB, $FreeCB, $ReallocCB, $StrdupCB, $CallocCB)
;   Curl_Slist_Append($List, $String = "", $AutoSplit = False)
;   Curl_Slist_Free_All($List)
;   Curl_Version()
;   Curl_Version_Info($Type = $CURLVERSION_NOW)
;   Curl_Easy_Escape($Handle, $String, $Encode = 1)
;   Curl_Easy_Init()
;   Curl_Easy_Cleanup($Handle)
;   Curl_Easy_DupHandle($Handle)
;   Curl_Easy_GetInfo($Handle, $Info)
;   Curl_Easy_Pause($Handle, $BitMask = $CURLPAUSE_ALL)
;   Curl_Easy_Perform($Handle)
;   Curl_Easy_Recv($Handle, $BufferLen = 65536)
;   Curl_Easy_Reset($Handle)
;   Curl_Easy_Send($Handle, $Data)
;   Curl_Easy_Setopt($Handle, $Option, $Value)
;   Curl_Easy_StrError($ErrorNum)
;   Curl_Easy_Unescape($Handle, $String, $Encode = 1)
;   Curl_Multi_Add_Handle($Handle, $EzHandle)
;   Curl_Multi_Cleanup($Handle)
;   Curl_Multi_Info_Read($Handle, ByRef $MsgsInQueue)
;   Curl_Multi_Init()
;   Curl_Multi_Perform($Handle, ByRef $RunningHandles)
;   Curl_Multi_Remove_Handle($Handle, $EzHandle)
;   Curl_Multi_Setopt($Handle, $Option, $Value)
;   Curl_Multi_StrError($ErrorNum)
;   Curl_DataWriteCallback()
;   Curl_DataReadCallback()
;   Curl_FileWriteCallback()
;   Curl_FileReadCallback()
;   Curl_Data_Put($Handle, $Data)
;   Curl_Data_Get($Handle)
;   Curl_Data_Cleanup($Handle)
;   Curl_Slist_ToArray($List)
; ============================================================================================================================

#Include-once
#Include "ISN_UDF_BinaryCall.au3"

Global Const $CURL_SOCKET_BAD = -1

Global Const $HTTPPOST_FILENAME    = BitShift(1, -0)
Global Const $HTTPPOST_READFILE    = BitShift(1, -1)
Global Const $HTTPPOST_PTRNAME     = BitShift(1, -2)
Global Const $HTTPPOST_PTRCONTENTS = BitShift(1, -3)
Global Const $HTTPPOST_BUFFER      = BitShift(1, -4)
Global Const $HTTPPOST_PTRBUFFER   = BitShift(1, -5)
Global Const $HTTPPOST_CALLBACK    = BitShift(1, -6)

Global Const $CURL_MAX_WRITE_SIZE = 16384
Global Const $CURL_MAX_HTTP_HEADER = 100*1024
Global Const $CURL_WRITEFUNC_PAUSE = 0x10000001

Global Enum _
  $CURLFILETYPE_FILE, _
  $CURLFILETYPE_DIRECTORY, _
  $CURLFILETYPE_SYMLINK, _
  $CURLFILETYPE_DEVICE_BLOCK, _
  $CURLFILETYPE_DEVICE_CHAR, _
  $CURLFILETYPE_NAMEDPIPE, _
  $CURLFILETYPE_SOCKET, _
  $CURLFILETYPE_DOOR, _
  $CURLFILETYPE_UNKNOWN

Global Const $CURLFINFOFLAG_KNOWN_FILENAME   = BitShift(1, -0)
Global Const $CURLFINFOFLAG_KNOWN_FILETYPE   = BitShift(1, -1)
Global Const $CURLFINFOFLAG_KNOWN_TIME       = BitShift(1, -2)
Global Const $CURLFINFOFLAG_KNOWN_PERM       = BitShift(1, -3)
Global Const $CURLFINFOFLAG_KNOWN_UID        = BitShift(1, -4)
Global Const $CURLFINFOFLAG_KNOWN_GID        = BitShift(1, -5)
Global Const $CURLFINFOFLAG_KNOWN_SIZE       = BitShift(1, -6)
Global Const $CURLFINFOFLAG_KNOWN_HLINKCOUNT = BitShift(1, -7)

Global Const $CURL_CHUNK_BGN_FUNC_OK = 0
Global Const $CURL_CHUNK_BGN_FUNC_FAIL = 1
Global Const $CURL_CHUNK_BGN_FUNC_SKIP = 2

Global Const $CURL_CHUNK_END_FUNC_OK = 0
Global Const $CURL_CHUNK_END_FUNC_FAIL = 1

Global Const $CURL_FNMATCHFUNC_MATCH = 0
Global Const $CURL_FNMATCHFUNC_NOMATCH = 1
Global Const $CURL_FNMATCHFUNC_FAIL = 2

Global Const $CURL_SEEKFUNC_OK = 0
Global Const $CURL_SEEKFUNC_FAIL = 1
Global Const $CURL_SEEKFUNC_CANTSEEK = 2

Global Const $CURL_READFUNC_ABORT = 0x10000000
Global Const $CURL_READFUNC_PAUSE = 0x10000001

Global Enum _
  $CURLSOCKTYPE_IPCXN, _
  $CURLSOCKTYPE_ACCEPT, _
  $CURLSOCKTYPE_LAST

Global Const $CURL_SOCKOPT_OK = 0
Global Const $CURL_SOCKOPT_ERROR = 1
Global Const $CURL_SOCKOPT_ALREADY_CONNECTED = 2

Global Enum _
  $CURLIOE_OK, _
  $CURLIOE_UNKNOWNCMD, _
  $CURLIOE_FAILRESTART, _
  $CURLIOE_LAST

Global Enum _
  $CURLIOCMD_NOP, _
  $CURLIOCMD_RESTARTREAD, _
  $CURLIOCMD_LAST

Global Enum _
  $CURLINFO_TEXT, _
  $CURLINFO_HEADER_IN, _
  $CURLINFO_HEADER_OUT, _
  $CURLINFO_DATA_IN, _
  $CURLINFO_DATA_OUT, _
  $CURLINFO_SSL_DATA_IN, _
  $CURLINFO_SSL_DATA_OUT, _
  $CURLINFO_END

Global Enum _
  $CURLE_OK, _
  $CURLE_UNSUPPORTED_PROTOCOL, _
  $CURLE_FAILED_INIT, _
  $CURLE_URL_MALFORMAT, _
  $CURLE_NOT_BUILT_IN, _
  $CURLE_COULDNT_RESOLVE_PROXY, _
  $CURLE_COULDNT_RESOLVE_HOST, _
  $CURLE_COULDNT_CONNECT, _
  $CURLE_FTP_WEIRD_SERVER_REPLY, _
  $CURLE_REMOTE_ACCESS_DENIED, _
  $CURLE_FTP_ACCEPT_FAILED, _
  $CURLE_FTP_WEIRD_PASS_REPLY, _
  $CURLE_FTP_ACCEPT_TIMEOUT, _
  $CURLE_FTP_WEIRD_PASV_REPLY, _
  $CURLE_FTP_WEIRD_227_FORMAT, _
  $CURLE_FTP_CANT_GET_HOST, _
  $CURLE_HTTP2, _
  $CURLE_FTP_COULDNT_SET_TYPE, _
  $CURLE_PARTIAL_FILE, _
  $CURLE_FTP_COULDNT_RETR_FILE, _
  $CURLE_OBSOLETE20, _
  $CURLE_QUOTE_ERROR, _
  $CURLE_HTTP_RETURNED_ERROR, _
  $CURLE_WRITE_ERROR, _
  $CURLE_OBSOLETE24, _
  $CURLE_UPLOAD_FAILED, _
  $CURLE_READ_ERROR, _
  $CURLE_OUT_OF_MEMORY, _
  $CURLE_OPERATION_TIMEDOUT, _
  $CURLE_OBSOLETE29, _
  $CURLE_FTP_PORT_FAILED, _
  $CURLE_FTP_COULDNT_USE_REST, _
  $CURLE_OBSOLETE32, _
  $CURLE_RANGE_ERROR, _
  $CURLE_HTTP_POST_ERROR, _
  $CURLE_SSL_CONNECT_ERROR, _
  $CURLE_BAD_DOWNLOAD_RESUME, _
  $CURLE_FILE_COULDNT_READ_FILE, _
  $CURLE_LDAP_CANNOT_BIND, _
  $CURLE_LDAP_SEARCH_FAILED, _
  $CURLE_OBSOLETE40, _
  $CURLE_FUNCTION_NOT_FOUND, _
  $CURLE_ABORTED_BY_CALLBACK, _
  $CURLE_BAD_FUNCTION_ARGUMENT, _
  $CURLE_OBSOLETE44, _
  $CURLE_INTERFACE_FAILED, _
  $CURLE_OBSOLETE46, _
  $CURLE_TOO_MANY_REDIRECTS , _
  $CURLE_UNKNOWN_OPTION, _
  $CURLE_TELNET_OPTION_SYNTAX, _
  $CURLE_OBSOLETE50, _
  $CURLE_PEER_FAILED_VERIFICATION, _
  $CURLE_GOT_NOTHING, _
  $CURLE_SSL_ENGINE_NOTFOUND, _
  $CURLE_SSL_ENGINE_SETFAILED, _
  $CURLE_SEND_ERROR, _
  $CURLE_RECV_ERROR, _
  $CURLE_OBSOLETE57, _
  $CURLE_SSL_CERTPROBLEM, _
  $CURLE_SSL_CIPHER, _
  $CURLE_SSL_CACERT, _
  $CURLE_BAD_CONTENT_ENCODING, _
  $CURLE_LDAP_INVALID_URL, _
  $CURLE_FILESIZE_EXCEEDED, _
  $CURLE_USE_SSL_FAILED, _
  $CURLE_SEND_FAIL_REWIND, _
  $CURLE_SSL_ENGINE_INITFAILED, _
  $CURLE_LOGIN_DENIED, _
  $CURLE_TFTP_NOTFOUND, _
  $CURLE_TFTP_PERM, _
  $CURLE_REMOTE_DISK_FULL, _
  $CURLE_TFTP_ILLEGAL, _
  $CURLE_TFTP_UNKNOWNID, _
  $CURLE_REMOTE_FILE_EXISTS, _
  $CURLE_TFTP_NOSUCHUSER, _
  $CURLE_CONV_FAILED, _
  $CURLE_CONV_REQD, _
  $CURLE_SSL_CACERT_BADFILE, _
  $CURLE_REMOTE_FILE_NOT_FOUND, _
  $CURLE_SSH, _
  $CURLE_SSL_SHUTDOWN_FAILED, _
  $CURLE_AGAIN, _
  $CURLE_SSL_CRL_BADFILE, _
  $CURLE_SSL_ISSUER_ERROR, _
  $CURLE_FTP_PRET_FAILED, _
  $CURLE_RTSP_CSEQ_ERROR, _
  $CURLE_RTSP_SESSION_ERROR, _
  $CURLE_FTP_BAD_FILE_LIST, _
  $CURLE_CHUNK_FAILED, _
  $CURLE_NO_CONNECTION_AVAILABLE, _
  $CURLE_SSL_PINNEDPUBKEYNOTMATCH, _
  $CURLE_SSL_INVALIDCERTSTATUS, _
  $CURL_LAST

Global Enum _
  $CURLPROXY_HTTP = 0, _
  $CURLPROXY_HTTP_1_0 = 1, _
  $CURLPROXY_SOCKS4 = 4, _
  $CURLPROXY_SOCKS5 = 5, _
  $CURLPROXY_SOCKS4A = 6, _
  $CURLPROXY_SOCKS5_HOSTNAME = 7

Global Const $CURLAUTH_NONE         = 0
Global Const $CURLAUTH_BASIC        = BitShift(1, -0)
Global Const $CURLAUTH_DIGEST       = BitShift(1, -1)
Global Const $CURLAUTH_NEGOTIATE    = BitShift(1, -2)
Global Const $CURLAUTH_GSSNEGOTIATE = $CURLAUTH_NEGOTIATE
Global Const $CURLAUTH_NTLM         = BitShift(1, -3)
Global Const $CURLAUTH_DIGEST_IE    = BitShift(1, -4)
Global Const $CURLAUTH_NTLM_WB      = BitShift(1, -5)
Global Const $CURLAUTH_ONLY         = BitShift(1, -31)
Global Const $CURLAUTH_ANY          = BitNOT($CURLAUTH_DIGEST_IE)
Global Const $CURLAUTH_ANYSAFE      = BitNOT(BitOR($CURLAUTH_BASIC, $CURLAUTH_DIGEST_IE))

Global Const $CURLSSH_AUTH_ANY       = BitNOT(0)
Global Const $CURLSSH_AUTH_NONE      = 0
Global Const $CURLSSH_AUTH_PUBLICKEY = BitShift(1, -0)
Global Const $CURLSSH_AUTH_PASSWORD  = BitShift(1, -1)
Global Const $CURLSSH_AUTH_HOST      = BitShift(1, -2)
Global Const $CURLSSH_AUTH_KEYBOARD  = BitShift(1, -3)
Global Const $CURLSSH_AUTH_AGENT     = BitShift(1, -4)
Global Const $CURLSSH_AUTH_DEFAULT   = $CURLSSH_AUTH_ANY

Global Const $CURLGSSAPI_DELEGATION_NONE        = 0
Global Const $CURLGSSAPI_DELEGATION_POLICY_FLAG = BitShift(1, -0)
Global Const $CURLGSSAPI_DELEGATION_FLAG        = BitShift(1, -1)

Global Const $CURL_ERROR_SIZE = 256

Global Enum _
  $CURLKHTYPE_UNKNOWN, _
  $CURLKHTYPE_RSA1, _
  $CURLKHTYPE_RSA, _
  $CURLKHTYPE_DSS

Global Enum _
  $CURLKHSTAT_FINE_ADD_TO_FILE, _
  $CURLKHSTAT_FINE, _
  $CURLKHSTAT_REJECT, _
  $CURLKHSTAT_DEFER, _
  $CURLKHSTAT_LAST

Global Enum _
  $CURLKHMATCH_OK, _
  $CURLKHMATCH_MISMATCH, _
  $CURLKHMATCH_MISSING, _
  $CURLKHMATCH_LAST

Global Enum _
  $CURLUSESSL_NONE, _
  $CURLUSESSL_TRY, _
  $CURLUSESSL_CONTROL, _
  $CURLUSESSL_ALL, _
  $CURLUSESSL_LAST

Global Const $CURLSSLOPT_ALLOW_BEAST = BitShift(1, -0)

Global Enum _
  $CURLFTPSSL_CCC_NONE, _
  $CURLFTPSSL_CCC_PASSIVE, _
  $CURLFTPSSL_CCC_ACTIVE, _
  $CURLFTPSSL_CCC_LAST

Global Enum _
  $CURLFTPAUTH_DEFAULT, _
  $CURLFTPAUTH_SSL, _
  $CURLFTPAUTH_TLS, _
  $CURLFTPAUTH_LAST

Global Enum _
  $CURLFTP_CREATE_DIR_NONE, _
  $CURLFTP_CREATE_DIR, _
  $CURLFTP_CREATE_DIR_RETRY, _
  $CURLFTP_CREATE_DIR_LAST

Global Enum _
  $CURLFTPMETHOD_DEFAULT, _
  $CURLFTPMETHOD_MULTICWD, _
  $CURLFTPMETHOD_NOCWD, _
  $CURLFTPMETHOD_SINGLECWD, _
  $CURLFTPMETHOD_LAST

Global Const $CURLHEADER_UNIFIED  = 0
Global Const $CURLHEADER_SEPARATE = 1

Global Const $CURLPROTO_HTTP   = BitShift(1, -0)
Global Const $CURLPROTO_HTTPS  = BitShift(1, -1)
Global Const $CURLPROTO_FTP    = BitShift(1, -2)
Global Const $CURLPROTO_FTPS   = BitShift(1, -3)
Global Const $CURLPROTO_SCP    = BitShift(1, -4)
Global Const $CURLPROTO_SFTP   = BitShift(1, -5)
Global Const $CURLPROTO_TELNET = BitShift(1, -6)
Global Const $CURLPROTO_LDAP   = BitShift(1, -7)
Global Const $CURLPROTO_LDAPS  = BitShift(1, -8)
Global Const $CURLPROTO_DICT   = BitShift(1, -9)
Global Const $CURLPROTO_FILE   = BitShift(1, -10)
Global Const $CURLPROTO_TFTP   = BitShift(1, -11)
Global Const $CURLPROTO_IMAP   = BitShift(1, -12)
Global Const $CURLPROTO_IMAPS  = BitShift(1, -13)
Global Const $CURLPROTO_POP3   = BitShift(1, -14)
Global Const $CURLPROTO_POP3S  = BitShift(1, -15)
Global Const $CURLPROTO_SMTP   = BitShift(1, -16)
Global Const $CURLPROTO_SMTPS  = BitShift(1, -17)
Global Const $CURLPROTO_RTSP   = BitShift(1, -18)
Global Const $CURLPROTO_RTMP   = BitShift(1, -19)
Global Const $CURLPROTO_RTMPT  = BitShift(1, -20)
Global Const $CURLPROTO_RTMPE  = BitShift(1, -21)
Global Const $CURLPROTO_RTMPTE = BitShift(1, -22)
Global Const $CURLPROTO_RTMPS  = BitShift(1, -23)
Global Const $CURLPROTO_RTMPTS = BitShift(1, -24)
Global Const $CURLPROTO_GOPHER = BitShift(1, -25)
Global Const $CURLPROTO_SMB    = BitShift(1, -26)
Global Const $CURLPROTO_SMBS   = BitShift(1, -27)
Global Const $CURLPROTO_ALL    = BitNOT(0)

Global Const $CURLOPTTYPE_LONG          = 0
Global Const $CURLOPTTYPE_OBJECTPOINT   = 10000
Global Const $CURLOPTTYPE_FUNCTIONPOINT = 20000
Global Const $CURLOPTTYPE_OFF_T         = 30000

Global Enum _
  $CURLOPT_WRITEDATA = $CURLOPTTYPE_OBJECTPOINT + 1, _
  $CURLOPT_URL = $CURLOPTTYPE_OBJECTPOINT + 2, _
  $CURLOPT_PORT = $CURLOPTTYPE_LONG + 3, _
  $CURLOPT_PROXY = $CURLOPTTYPE_OBJECTPOINT + 4, _
  $CURLOPT_USERPWD = $CURLOPTTYPE_OBJECTPOINT + 5, _
  $CURLOPT_PROXYUSERPWD = $CURLOPTTYPE_OBJECTPOINT + 6, _
  $CURLOPT_RANGE = $CURLOPTTYPE_OBJECTPOINT + 7, _
  $CURLOPT_READDATA = $CURLOPTTYPE_OBJECTPOINT + 9, _
  $CURLOPT_ERRORBUFFER = $CURLOPTTYPE_OBJECTPOINT + 10, _
  $CURLOPT_WRITEFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 11, _
  $CURLOPT_READFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 12, _
  $CURLOPT_TIMEOUT = $CURLOPTTYPE_LONG + 13, _
  $CURLOPT_INFILESIZE = $CURLOPTTYPE_LONG + 14, _
  $CURLOPT_POSTFIELDS = $CURLOPTTYPE_OBJECTPOINT + 15, _
  $CURLOPT_REFERER = $CURLOPTTYPE_OBJECTPOINT + 16, _
  $CURLOPT_FTPPORT = $CURLOPTTYPE_OBJECTPOINT + 17, _
  $CURLOPT_USERAGENT = $CURLOPTTYPE_OBJECTPOINT + 18, _
  $CURLOPT_LOW_SPEED_LIMIT = $CURLOPTTYPE_LONG + 19, _
  $CURLOPT_LOW_SPEED_TIME = $CURLOPTTYPE_LONG + 20, _
  $CURLOPT_RESUME_FROM = $CURLOPTTYPE_LONG + 21, _
  $CURLOPT_COOKIE = $CURLOPTTYPE_OBJECTPOINT + 22, _
  $CURLOPT_HTTPHEADER = $CURLOPTTYPE_OBJECTPOINT + 23, _
  $CURLOPT_HTTPPOST = $CURLOPTTYPE_OBJECTPOINT + 24, _
  $CURLOPT_SSLCERT = $CURLOPTTYPE_OBJECTPOINT + 25, _
  $CURLOPT_KEYPASSWD = $CURLOPTTYPE_OBJECTPOINT + 26, _
  $CURLOPT_CRLF = $CURLOPTTYPE_LONG + 27, _
  $CURLOPT_QUOTE = $CURLOPTTYPE_OBJECTPOINT + 28, _
  $CURLOPT_HEADERDATA = $CURLOPTTYPE_OBJECTPOINT + 29, _
  $CURLOPT_COOKIEFILE = $CURLOPTTYPE_OBJECTPOINT + 31, _
  $CURLOPT_SSLVERSION = $CURLOPTTYPE_LONG + 32, _
  $CURLOPT_TIMECONDITION = $CURLOPTTYPE_LONG + 33, _
  $CURLOPT_TIMEVALUE = $CURLOPTTYPE_LONG + 34, _
  $CURLOPT_CUSTOMREQUEST = $CURLOPTTYPE_OBJECTPOINT + 36, _
  $CURLOPT_STDERR = $CURLOPTTYPE_OBJECTPOINT + 37, _
  $CURLOPT_POSTQUOTE = $CURLOPTTYPE_OBJECTPOINT + 39, _
  $CURLOPT_OBSOLETE40 = $CURLOPTTYPE_OBJECTPOINT + 40, _
  $CURLOPT_VERBOSE = $CURLOPTTYPE_LONG + 41, _
  $CURLOPT_HEADER = $CURLOPTTYPE_LONG + 42, _
  $CURLOPT_NOPROGRESS = $CURLOPTTYPE_LONG + 43, _
  $CURLOPT_NOBODY = $CURLOPTTYPE_LONG + 44, _
  $CURLOPT_FAILONERROR = $CURLOPTTYPE_LONG + 45, _
  $CURLOPT_UPLOAD = $CURLOPTTYPE_LONG + 46, _
  $CURLOPT_POST = $CURLOPTTYPE_LONG + 47, _
  $CURLOPT_DIRLISTONLY = $CURLOPTTYPE_LONG + 48, _
  $CURLOPT_APPEND = $CURLOPTTYPE_LONG + 50, _
  $CURLOPT_NETRC = $CURLOPTTYPE_LONG + 51, _
  $CURLOPT_FOLLOWLOCATION = $CURLOPTTYPE_LONG + 52, _
  $CURLOPT_TRANSFERTEXT = $CURLOPTTYPE_LONG + 53, _
  $CURLOPT_PUT = $CURLOPTTYPE_LONG + 54, _
  $CURLOPT_PROGRESSFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 56, _
  $CURLOPT_PROGRESSDATA = $CURLOPTTYPE_OBJECTPOINT + 57, _
  $CURLOPT_AUTOREFERER = $CURLOPTTYPE_LONG + 58, _
  $CURLOPT_PROXYPORT = $CURLOPTTYPE_LONG + 59, _
  $CURLOPT_POSTFIELDSIZE = $CURLOPTTYPE_LONG + 60, _
  $CURLOPT_HTTPPROXYTUNNEL = $CURLOPTTYPE_LONG + 61, _
  $CURLOPT_INTERFACE = $CURLOPTTYPE_OBJECTPOINT + 62, _
  $CURLOPT_KRBLEVEL = $CURLOPTTYPE_OBJECTPOINT + 63, _
  $CURLOPT_SSL_VERIFYPEER = $CURLOPTTYPE_LONG + 64, _
  $CURLOPT_CAINFO = $CURLOPTTYPE_OBJECTPOINT + 65, _
  $CURLOPT_MAXREDIRS = $CURLOPTTYPE_LONG + 68, _
  $CURLOPT_FILETIME = $CURLOPTTYPE_LONG + 69, _
  $CURLOPT_TELNETOPTIONS = $CURLOPTTYPE_OBJECTPOINT + 70, _
  $CURLOPT_MAXCONNECTS = $CURLOPTTYPE_LONG + 71, _
  $CURLOPT_OBSOLETE72 = $CURLOPTTYPE_LONG + 72, _
  $CURLOPT_FRESH_CONNECT = $CURLOPTTYPE_LONG + 74, _
  $CURLOPT_FORBID_REUSE = $CURLOPTTYPE_LONG + 75, _
  $CURLOPT_RANDOM_FILE = $CURLOPTTYPE_OBJECTPOINT + 76, _
  $CURLOPT_EGDSOCKET = $CURLOPTTYPE_OBJECTPOINT + 77, _
  $CURLOPT_CONNECTTIMEOUT = $CURLOPTTYPE_LONG + 78, _
  $CURLOPT_HEADERFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 79, _
  $CURLOPT_HTTPGET = $CURLOPTTYPE_LONG + 80, _
  $CURLOPT_SSL_VERIFYHOST = $CURLOPTTYPE_LONG + 81, _
  $CURLOPT_COOKIEJAR = $CURLOPTTYPE_OBJECTPOINT + 82, _
  $CURLOPT_SSL_CIPHER_LIST = $CURLOPTTYPE_OBJECTPOINT + 83, _
  $CURLOPT_HTTP_VERSION = $CURLOPTTYPE_LONG + 84, _
  $CURLOPT_FTP_USE_EPSV = $CURLOPTTYPE_LONG + 85, _
  $CURLOPT_SSLCERTTYPE = $CURLOPTTYPE_OBJECTPOINT + 86, _
  $CURLOPT_SSLKEY = $CURLOPTTYPE_OBJECTPOINT + 87, _
  $CURLOPT_SSLKEYTYPE = $CURLOPTTYPE_OBJECTPOINT + 88, _
  $CURLOPT_SSLENGINE = $CURLOPTTYPE_OBJECTPOINT + 89, _
  $CURLOPT_SSLENGINE_DEFAULT = $CURLOPTTYPE_LONG + 90, _
  $CURLOPT_DNS_USE_GLOBAL_CACHE = $CURLOPTTYPE_LONG + 91, _
  $CURLOPT_DNS_CACHE_TIMEOUT = $CURLOPTTYPE_LONG + 92, _
  $CURLOPT_PREQUOTE = $CURLOPTTYPE_OBJECTPOINT + 93, _
  $CURLOPT_DEBUGFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 94, _
  $CURLOPT_DEBUGDATA = $CURLOPTTYPE_OBJECTPOINT + 95, _
  $CURLOPT_COOKIESESSION = $CURLOPTTYPE_LONG + 96, _
  $CURLOPT_CAPATH = $CURLOPTTYPE_OBJECTPOINT + 97, _
  $CURLOPT_BUFFERSIZE = $CURLOPTTYPE_LONG + 98, _
  $CURLOPT_NOSIGNAL = $CURLOPTTYPE_LONG + 99, _
  $CURLOPT_SHARE = $CURLOPTTYPE_OBJECTPOINT + 100, _
  $CURLOPT_PROXYTYPE = $CURLOPTTYPE_LONG + 101, _
  $CURLOPT_ACCEPT_ENCODING = $CURLOPTTYPE_OBJECTPOINT + 102, _
  $CURLOPT_PRIVATE = $CURLOPTTYPE_OBJECTPOINT + 103, _
  $CURLOPT_HTTP200ALIASES = $CURLOPTTYPE_OBJECTPOINT + 104, _
  $CURLOPT_UNRESTRICTED_AUTH = $CURLOPTTYPE_LONG + 105, _
  $CURLOPT_FTP_USE_EPRT = $CURLOPTTYPE_LONG + 106, _
  $CURLOPT_HTTPAUTH = $CURLOPTTYPE_LONG + 107, _
  $CURLOPT_SSL_CTX_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 108, _
  $CURLOPT_SSL_CTX_DATA = $CURLOPTTYPE_OBJECTPOINT + 109, _
  $CURLOPT_FTP_CREATE_MISSING_DIRS = $CURLOPTTYPE_LONG + 110, _
  $CURLOPT_PROXYAUTH = $CURLOPTTYPE_LONG + 111, _
  $CURLOPT_FTP_RESPONSE_TIMEOUT = $CURLOPTTYPE_LONG + 112, _
  $CURLOPT_IPRESOLVE = $CURLOPTTYPE_LONG + 113, _
  $CURLOPT_MAXFILESIZE = $CURLOPTTYPE_LONG + 114, _
  $CURLOPT_INFILESIZE_LARGE = $CURLOPTTYPE_OFF_T + 115, _
  $CURLOPT_RESUME_FROM_LARGE = $CURLOPTTYPE_OFF_T + 116, _
  $CURLOPT_MAXFILESIZE_LARGE = $CURLOPTTYPE_OFF_T + 117, _
  $CURLOPT_NETRC_FILE = $CURLOPTTYPE_OBJECTPOINT + 118, _
  $CURLOPT_USE_SSL = $CURLOPTTYPE_LONG + 119, _
  $CURLOPT_POSTFIELDSIZE_LARGE = $CURLOPTTYPE_OFF_T + 120, _
  $CURLOPT_TCP_NODELAY = $CURLOPTTYPE_LONG + 121, _
  $CURLOPT_FTPSSLAUTH = $CURLOPTTYPE_LONG + 129, _
  $CURLOPT_IOCTLFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 130, _
  $CURLOPT_IOCTLDATA = $CURLOPTTYPE_OBJECTPOINT + 131, _
  $CURLOPT_FTP_ACCOUNT = $CURLOPTTYPE_OBJECTPOINT + 134, _
  $CURLOPT_COOKIELIST = $CURLOPTTYPE_OBJECTPOINT + 135, _
  $CURLOPT_IGNORE_CONTENT_LENGTH = $CURLOPTTYPE_LONG + 136, _
  $CURLOPT_FTP_SKIP_PASV_IP = $CURLOPTTYPE_LONG + 137, _
  $CURLOPT_FTP_FILEMETHOD = $CURLOPTTYPE_LONG + 138, _
  $CURLOPT_LOCALPORT = $CURLOPTTYPE_LONG + 139, _
  $CURLOPT_LOCALPORTRANGE = $CURLOPTTYPE_LONG + 140, _
  $CURLOPT_CONNECT_ONLY = $CURLOPTTYPE_LONG + 141, _
  $CURLOPT_CONV_FROM_NETWORK_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 142, _
  $CURLOPT_CONV_TO_NETWORK_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 143, _
  $CURLOPT_CONV_FROM_UTF8_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 144, _
  $CURLOPT_MAX_SEND_SPEED_LARGE = $CURLOPTTYPE_OFF_T + 145, _
  $CURLOPT_MAX_RECV_SPEED_LARGE = $CURLOPTTYPE_OFF_T + 146, _
  $CURLOPT_FTP_ALTERNATIVE_TO_USER = $CURLOPTTYPE_OBJECTPOINT + 147, _
  $CURLOPT_SOCKOPTFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 148, _
  $CURLOPT_SOCKOPTDATA = $CURLOPTTYPE_OBJECTPOINT + 149, _
  $CURLOPT_SSL_SESSIONID_CACHE = $CURLOPTTYPE_LONG + 150, _
  $CURLOPT_SSH_AUTH_TYPES = $CURLOPTTYPE_LONG + 151, _
  $CURLOPT_SSH_PUBLIC_KEYFILE = $CURLOPTTYPE_OBJECTPOINT + 152, _
  $CURLOPT_SSH_PRIVATE_KEYFILE = $CURLOPTTYPE_OBJECTPOINT + 153, _
  $CURLOPT_FTP_SSL_CCC = $CURLOPTTYPE_LONG + 154, _
  $CURLOPT_TIMEOUT_MS = $CURLOPTTYPE_LONG + 155, _
  $CURLOPT_CONNECTTIMEOUT_MS = $CURLOPTTYPE_LONG + 156, _
  $CURLOPT_HTTP_TRANSFER_DECODING = $CURLOPTTYPE_LONG + 157, _
  $CURLOPT_HTTP_CONTENT_DECODING = $CURLOPTTYPE_LONG + 158, _
  $CURLOPT_NEW_FILE_PERMS = $CURLOPTTYPE_LONG + 159, _
  $CURLOPT_NEW_DIRECTORY_PERMS = $CURLOPTTYPE_LONG + 160, _
  $CURLOPT_POSTREDIR = $CURLOPTTYPE_LONG + 161, _
  $CURLOPT_SSH_HOST_PUBLIC_KEY_MD5 = $CURLOPTTYPE_OBJECTPOINT + 162, _
  $CURLOPT_OPENSOCKETFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 163, _
  $CURLOPT_OPENSOCKETDATA = $CURLOPTTYPE_OBJECTPOINT + 164, _
  $CURLOPT_COPYPOSTFIELDS = $CURLOPTTYPE_OBJECTPOINT + 165, _
  $CURLOPT_PROXY_TRANSFER_MODE = $CURLOPTTYPE_LONG + 166, _
  $CURLOPT_SEEKFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 167, _
  $CURLOPT_SEEKDATA = $CURLOPTTYPE_OBJECTPOINT + 168, _
  $CURLOPT_CRLFILE = $CURLOPTTYPE_OBJECTPOINT + 169, _
  $CURLOPT_ISSUERCERT = $CURLOPTTYPE_OBJECTPOINT + 170, _
  $CURLOPT_ADDRESS_SCOPE = $CURLOPTTYPE_LONG + 171, _
  $CURLOPT_CERTINFO = $CURLOPTTYPE_LONG + 172, _
  $CURLOPT_USERNAME = $CURLOPTTYPE_OBJECTPOINT + 173, _
  $CURLOPT_PASSWORD = $CURLOPTTYPE_OBJECTPOINT + 174, _
  $CURLOPT_PROXYUSERNAME = $CURLOPTTYPE_OBJECTPOINT + 175, _
  $CURLOPT_PROXYPASSWORD = $CURLOPTTYPE_OBJECTPOINT + 176, _
  $CURLOPT_NOPROXY = $CURLOPTTYPE_OBJECTPOINT + 177, _
  $CURLOPT_TFTP_BLKSIZE = $CURLOPTTYPE_LONG + 178, _
  $CURLOPT_SOCKS5_GSSAPI_SERVICE = $CURLOPTTYPE_OBJECTPOINT + 179, _
  $CURLOPT_SOCKS5_GSSAPI_NEC = $CURLOPTTYPE_LONG + 180, _
  $CURLOPT_PROTOCOLS = $CURLOPTTYPE_LONG + 181, _
  $CURLOPT_REDIR_PROTOCOLS = $CURLOPTTYPE_LONG + 182, _
  $CURLOPT_SSH_KNOWNHOSTS = $CURLOPTTYPE_OBJECTPOINT + 183, _
  $CURLOPT_SSH_KEYFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 184, _
  $CURLOPT_SSH_KEYDATA = $CURLOPTTYPE_OBJECTPOINT + 185, _
  $CURLOPT_MAIL_FROM = $CURLOPTTYPE_OBJECTPOINT + 186, _
  $CURLOPT_MAIL_RCPT = $CURLOPTTYPE_OBJECTPOINT + 187, _
  $CURLOPT_FTP_USE_PRET = $CURLOPTTYPE_LONG + 188, _
  $CURLOPT_RTSP_REQUEST = $CURLOPTTYPE_LONG + 189, _
  $CURLOPT_RTSP_SESSION_ID = $CURLOPTTYPE_OBJECTPOINT + 190, _
  $CURLOPT_RTSP_STREAM_URI = $CURLOPTTYPE_OBJECTPOINT + 191, _
  $CURLOPT_RTSP_TRANSPORT = $CURLOPTTYPE_OBJECTPOINT + 192, _
  $CURLOPT_RTSP_CLIENT_CSEQ = $CURLOPTTYPE_LONG + 193, _
  $CURLOPT_RTSP_SERVER_CSEQ = $CURLOPTTYPE_LONG + 194, _
  $CURLOPT_INTERLEAVEDATA = $CURLOPTTYPE_OBJECTPOINT + 195, _
  $CURLOPT_INTERLEAVEFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 196, _
  $CURLOPT_WILDCARDMATCH = $CURLOPTTYPE_LONG + 197, _
  $CURLOPT_CHUNK_BGN_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 198, _
  $CURLOPT_CHUNK_END_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 199, _
  $CURLOPT_FNMATCH_FUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 200, _
  $CURLOPT_CHUNK_DATA = $CURLOPTTYPE_OBJECTPOINT + 201, _
  $CURLOPT_FNMATCH_DATA = $CURLOPTTYPE_OBJECTPOINT + 202, _
  $CURLOPT_RESOLVE = $CURLOPTTYPE_OBJECTPOINT + 203, _
  $CURLOPT_TLSAUTH_USERNAME = $CURLOPTTYPE_OBJECTPOINT + 204, _
  $CURLOPT_TLSAUTH_PASSWORD = $CURLOPTTYPE_OBJECTPOINT + 205, _
  $CURLOPT_TLSAUTH_TYPE = $CURLOPTTYPE_OBJECTPOINT + 206, _
  $CURLOPT_TRANSFER_ENCODING = $CURLOPTTYPE_LONG + 207, _
  $CURLOPT_CLOSESOCKETFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 208, _
  $CURLOPT_CLOSESOCKETDATA = $CURLOPTTYPE_OBJECTPOINT + 209, _
  $CURLOPT_GSSAPI_DELEGATION = $CURLOPTTYPE_LONG + 210, _
  $CURLOPT_DNS_SERVERS = $CURLOPTTYPE_OBJECTPOINT + 211, _
  $CURLOPT_ACCEPTTIMEOUT_MS = $CURLOPTTYPE_LONG + 212, _
  $CURLOPT_TCP_KEEPALIVE = $CURLOPTTYPE_LONG + 213, _
  $CURLOPT_TCP_KEEPIDLE = $CURLOPTTYPE_LONG + 214, _
  $CURLOPT_TCP_KEEPINTVL = $CURLOPTTYPE_LONG + 215, _
  $CURLOPT_SSL_OPTIONS = $CURLOPTTYPE_LONG + 216, _
  $CURLOPT_MAIL_AUTH = $CURLOPTTYPE_OBJECTPOINT + 217, _
  $CURLOPT_SASL_IR = $CURLOPTTYPE_LONG + 218, _
  $CURLOPT_XFERINFOFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 219, _
  $CURLOPT_XOAUTH2_BEARER = $CURLOPTTYPE_OBJECTPOINT + 220, _
  $CURLOPT_DNS_INTERFACE = $CURLOPTTYPE_OBJECTPOINT + 221, _
  $CURLOPT_DNS_LOCAL_IP4 = $CURLOPTTYPE_OBJECTPOINT + 222, _
  $CURLOPT_DNS_LOCAL_IP6 = $CURLOPTTYPE_OBJECTPOINT + 223, _
  $CURLOPT_LOGIN_OPTIONS = $CURLOPTTYPE_OBJECTPOINT + 224, _
  $CURLOPT_SSL_ENABLE_NPN = $CURLOPTTYPE_LONG + 225, _
  $CURLOPT_SSL_ENABLE_ALPN = $CURLOPTTYPE_LONG + 226, _
  $CURLOPT_EXPECT_100_TIMEOUT_MS = $CURLOPTTYPE_LONG + 227, _
  $CURLOPT_PROXYHEADER = $CURLOPTTYPE_OBJECTPOINT + 228, _
  $CURLOPT_HEADEROPT = $CURLOPTTYPE_LONG + 229, _
  $CURLOPT_PINNEDPUBLICKEY = $CURLOPTTYPE_OBJECTPOINT + 230, _
  $CURLOPT_UNIX_SOCKET_PATH = $CURLOPTTYPE_OBJECTPOINT + 231, _
  $CURLOPT_SSL_VERIFYSTATUS = $CURLOPTTYPE_LONG + 232, _
  $CURLOPT_SSL_FALSESTART = $CURLOPTTYPE_LONG + 233, _
  $CURLOPT_PATH_AS_IS = $CURLOPTTYPE_LONG + 234, _
  $CURLOPT_LASTENTRY

Global Const $CURLOPT_XFERINFODATA = $CURLOPT_PROGRESSDATA
Global Const $CURLOPT_SERVER_RESPONSE_TIMEOUT = $CURLOPT_FTP_RESPONSE_TIMEOUT
Global Const $CURLOPT_POST301 = $CURLOPT_POSTREDIR
Global Const $CURLOPT_SSLKEYPASSWD = $CURLOPT_KEYPASSWD
Global Const $CURLOPT_FTPAPPEND = $CURLOPT_APPEND
Global Const $CURLOPT_FTPLISTONLY = $CURLOPT_DIRLISTONLY
Global Const $CURLOPT_FTP_SSL = $CURLOPT_USE_SSL
Global Const $CURLOPT_SSLCERTPASSWD = $CURLOPT_KEYPASSWD
Global Const $CURLOPT_KRB4LEVEL = $CURLOPT_KRBLEVEL
Global Const $CURLOPT_RTSPHEADER = $CURLOPT_HTTPHEADER

Global Const $CURL_IPRESOLVE_WHATEVER = 0
Global Const $CURL_IPRESOLVE_V4       = 1
Global Const $CURL_IPRESOLVE_V6       = 2

Global Enum _
  $CURL_HTTP_VERSION_NONE, _
  $CURL_HTTP_VERSION_1_0, _
  $CURL_HTTP_VERSION_1_1, _
  $CURL_HTTP_VERSION_2_0, _
  $CURL_HTTP_VERSION_LAST

Global Enum _
  $CURL_RTSPREQ_NONE, _
  $CURL_RTSPREQ_OPTIONS, _
  $CURL_RTSPREQ_DESCRIBE, _
  $CURL_RTSPREQ_ANNOUNCE, _
  $CURL_RTSPREQ_SETUP, _
  $CURL_RTSPREQ_PLAY, _
  $CURL_RTSPREQ_PAUSE, _
  $CURL_RTSPREQ_TEARDOWN, _
  $CURL_RTSPREQ_GET_PARAMETER, _
  $CURL_RTSPREQ_SET_PARAMETER, _
  $CURL_RTSPREQ_RECORD, _
  $CURL_RTSPREQ_RECEIVE, _
  $CURL_RTSPREQ_LAST

Global Enum _
  $CURL_NETRC_IGNORED, _
  $CURL_NETRC_OPTIONAL, _
  $CURL_NETRC_REQUIRED, _
  $CURL_NETRC_LAST

Global Enum _
  $CURL_SSLVERSION_DEFAULT, _
  $CURL_SSLVERSION_TLSv1, _
  $CURL_SSLVERSION_SSLv2, _
  $CURL_SSLVERSION_SSLv3, _
  $CURL_SSLVERSION_TLSv1_0, _
  $CURL_SSLVERSION_TLSv1_1, _
  $CURL_SSLVERSION_TLSv1_2, _
  $CURL_SSLVERSION_LAST

Global Enum _
  $CURL_TLSAUTH_NONE, _
  $CURL_TLSAUTH_SRP, _
  $CURL_TLSAUTH_LAST

Global Const $CURL_REDIR_GET_ALL  = 0
Global Const $CURL_REDIR_POST_301 = 1
Global Const $CURL_REDIR_POST_302 = 2
Global Const $CURL_REDIR_POST_303 = 4
Global Const $CURL_REDIR_POST_ALL = BitOR($CURL_REDIR_POST_301, $CURL_REDIR_POST_302, $CURL_REDIR_POST_303)

Global Enum _
  $CURL_TIMECOND_NONE, _
  $CURL_TIMECOND_IFMODSINCE, _
  $CURL_TIMECOND_IFUNMODSINCE, _
  $CURL_TIMECOND_LASTMOD, _
  $CURL_TIMECOND_LAST

Global Enum _
  $CURLFORM_NOTHING, _
  $CURLFORM_COPYNAME, _
  $CURLFORM_PTRNAME, _
  $CURLFORM_NAMELENGTH, _
  $CURLFORM_COPYCONTENTS, _
  $CURLFORM_PTRCONTENTS, _
  $CURLFORM_CONTENTSLENGTH, _
  $CURLFORM_FILECONTENT, _
  $CURLFORM_ARRAY, _
  $CURLFORM_OBSOLETE, _
  $CURLFORM_FILE, _
  $CURLFORM_BUFFER, _
  $CURLFORM_BUFFERPTR, _
  $CURLFORM_BUFFERLENGTH, _
  $CURLFORM_CONTENTTYPE, _
  $CURLFORM_CONTENTHEADER, _
  $CURLFORM_FILENAME, _
  $CURLFORM_END, _
  $CURLFORM_OBSOLETE2, _
  $CURLFORM_STREAM, _
  $CURLFORM_LASTENTRY

Global Enum _
  $CURL_FORMADD_OK, _
  $CURL_FORMADD_MEMORY, _
  $CURL_FORMADD_OPTION_TWICE, _
  $CURL_FORMADD_NULL, _
  $CURL_FORMADD_UNKNOWN_OPTION, _
  $CURL_FORMADD_INCOMPLETE, _
  $CURL_FORMADD_ILLEGAL_ARRAY, _
  $CURL_FORMADD_DISABLED, _
  $CURL_FORMADD_LAST

Global Enum _
  $CURLSSLBACKEND_NONE, _
  $CURLSSLBACKEND_OPENSSL, _
  $CURLSSLBACKEND_GNUTLS, _
  $CURLSSLBACKEND_NSS, _
  $CURLSSLBACKEND_OBSOLETE4, _
  $CURLSSLBACKEND_GSKIT, _
  $CURLSSLBACKEND_POLARSSL, _
  $CURLSSLBACKEND_CYASSL, _
  $CURLSSLBACKEND_SCHANNEL, _
  $CURLSSLBACKEND_DARWINSSL, _
  $CURLSSLBACKEND_AXTLS

Global Const $CURLINFO_STRING   = 0x100000
Global Const $CURLINFO_LONG     = 0x200000
Global Const $CURLINFO_DOUBLE   = 0x300000
Global Const $CURLINFO_SLIST    = 0x400000
Global Const $CURLINFO_MASK     = 0x0fffff
Global Const $CURLINFO_TYPEMASK = 0xf00000

Global Enum _
  $CURLINFO_NONE, _
  $CURLINFO_EFFECTIVE_URL    = $CURLINFO_STRING + 1, _
  $CURLINFO_RESPONSE_CODE    = $CURLINFO_LONG   + 2, _
  $CURLINFO_TOTAL_TIME       = $CURLINFO_DOUBLE + 3, _
  $CURLINFO_NAMELOOKUP_TIME  = $CURLINFO_DOUBLE + 4, _
  $CURLINFO_CONNECT_TIME     = $CURLINFO_DOUBLE + 5, _
  $CURLINFO_PRETRANSFER_TIME = $CURLINFO_DOUBLE + 6, _
  $CURLINFO_SIZE_UPLOAD      = $CURLINFO_DOUBLE + 7, _
  $CURLINFO_SIZE_DOWNLOAD    = $CURLINFO_DOUBLE + 8, _
  $CURLINFO_SPEED_DOWNLOAD   = $CURLINFO_DOUBLE + 9, _
  $CURLINFO_SPEED_UPLOAD     = $CURLINFO_DOUBLE + 10, _
  $CURLINFO_HEADER_SIZE      = $CURLINFO_LONG   + 11, _
  $CURLINFO_REQUEST_SIZE     = $CURLINFO_LONG   + 12, _
  $CURLINFO_SSL_VERIFYRESULT = $CURLINFO_LONG   + 13, _
  $CURLINFO_FILETIME         = $CURLINFO_LONG   + 14, _
  $CURLINFO_CONTENT_LENGTH_DOWNLOAD = $CURLINFO_DOUBLE + 15, _
  $CURLINFO_CONTENT_LENGTH_UPLOAD   = $CURLINFO_DOUBLE + 16, _
  $CURLINFO_STARTTRANSFER_TIME      = $CURLINFO_DOUBLE + 17, _
  $CURLINFO_CONTENT_TYPE     = $CURLINFO_STRING + 18, _
  $CURLINFO_REDIRECT_TIME    = $CURLINFO_DOUBLE + 19, _
  $CURLINFO_REDIRECT_COUNT   = $CURLINFO_LONG   + 20, _
  $CURLINFO_PRIVATE          = $CURLINFO_STRING + 21, _
  $CURLINFO_HTTP_CONNECTCODE = $CURLINFO_LONG   + 22, _
  $CURLINFO_HTTPAUTH_AVAIL   = $CURLINFO_LONG   + 23, _
  $CURLINFO_PROXYAUTH_AVAIL  = $CURLINFO_LONG   + 24, _
  $CURLINFO_OS_ERRNO         = $CURLINFO_LONG   + 25, _
  $CURLINFO_NUM_CONNECTS     = $CURLINFO_LONG   + 26, _
  $CURLINFO_SSL_ENGINES      = $CURLINFO_SLIST  + 27, _
  $CURLINFO_COOKIELIST       = $CURLINFO_SLIST  + 28, _
  $CURLINFO_LASTSOCKET       = $CURLINFO_LONG   + 29, _
  $CURLINFO_FTP_ENTRY_PATH   = $CURLINFO_STRING + 30, _
  $CURLINFO_REDIRECT_URL     = $CURLINFO_STRING + 31, _
  $CURLINFO_PRIMARY_IP       = $CURLINFO_STRING + 32, _
  $CURLINFO_APPCONNECT_TIME  = $CURLINFO_DOUBLE + 33, _
  $CURLINFO_CERTINFO         = $CURLINFO_SLIST  + 34, _
  $CURLINFO_CONDITION_UNMET  = $CURLINFO_LONG   + 35, _
  $CURLINFO_RTSP_SESSION_ID  = $CURLINFO_STRING + 36, _
  $CURLINFO_RTSP_CLIENT_CSEQ = $CURLINFO_LONG   + 37, _
  $CURLINFO_RTSP_SERVER_CSEQ = $CURLINFO_LONG   + 38, _
  $CURLINFO_RTSP_CSEQ_RECV   = $CURLINFO_LONG   + 39, _
  $CURLINFO_PRIMARY_PORT     = $CURLINFO_LONG   + 40, _
  $CURLINFO_LOCAL_IP         = $CURLINFO_STRING + 41, _
  $CURLINFO_LOCAL_PORT       = $CURLINFO_LONG   + 42, _
  $CURLINFO_TLS_SESSION      = $CURLINFO_SLIST  + 43, _
  $CURLINFO_LASTONE          = 43

Global Const $CURLINFO_HTTP_CODE = $CURLINFO_RESPONSE_CODE

Global Enum _
  $CURLCLOSEPOLICY_NONE, _
  $CURLCLOSEPOLICY_OLDEST, _
  $CURLCLOSEPOLICY_LEAST_RECENTLY_USED, _
  $CURLCLOSEPOLICY_LEAST_TRAFFIC, _
  $CURLCLOSEPOLICY_SLOWEST, _
  $CURLCLOSEPOLICY_CALLBACK, _
  $CURLCLOSEPOLICY_LAST

Global Const $CURL_GLOBAL_SSL   = BitShift(1, -0)
Global Const $CURL_GLOBAL_WIN32 = BitShift(1, -1)
Global Const $CURL_GLOBAL_ALL   = BitOR($CURL_GLOBAL_SSL, $CURL_GLOBAL_WIN32)
Global Const $CURL_GLOBAL_NOTHING = 0
Global Const $CURL_GLOBAL_DEFAULT = $CURL_GLOBAL_ALL
Global Const $CURL_GLOBAL_ACK_EINTR = BitShift(1, -2)

Global Enum _
  $CURL_LOCK_DATA_NONE, _
  $CURL_LOCK_DATA_SHARE, _
  $CURL_LOCK_DATA_COOKIE, _
  $CURL_LOCK_DATA_DNS, _
  $CURL_LOCK_DATA_SSL_SESSION, _
  $CURL_LOCK_DATA_CONNECT, _
  $CURL_LOCK_DATA_LAST

Global Enum _
  $CURL_LOCK_ACCESS_NONE, _
  $CURL_LOCK_ACCESS_SHARED, _
  $CURL_LOCK_ACCESS_SINGLE, _
  $CURL_LOCK_ACCESS_LAST

Global Enum _
  $CURLSHE_OK, _
  $CURLSHE_BAD_OPTION, _
  $CURLSHE_IN_USE, _
  $CURLSHE_INVALID, _
  $CURLSHE_NOMEM, _
  $CURLSHE_NOT_BUILT_IN, _
  $CURLSHE_LAST

Global Enum _
  $CURLSHOPT_NONE, _
  $CURLSHOPT_SHARE, _
  $CURLSHOPT_UNSHARE, _
  $CURLSHOPT_LOCKFUNC, _
  $CURLSHOPT_UNLOCKFUNC, _
  $CURLSHOPT_USERDATA, _
  $CURLSHOPT_LAST

Global Enum _
  $CURLVERSION_FIRST, _
  $CURLVERSION_SECOND, _
  $CURLVERSION_THIRD, _
  $CURLVERSION_FOURTH, _
  $CURLVERSION_LAST

Global Const $CURLVERSION_NOW = $CURLVERSION_FOURTH

Global Const $CURL_VERSION_IPV6         = BitShift(1, -0)
Global Const $CURL_VERSION_KERBEROS4    = BitShift(1, -1)
Global Const $CURL_VERSION_SSL          = BitShift(1, -2)
Global Const $CURL_VERSION_LIBZ         = BitShift(1, -3)
Global Const $CURL_VERSION_NTLM         = BitShift(1, -4)
Global Const $CURL_VERSION_GSSNEGOTIATE = BitShift(1, -5)
Global Const $CURL_VERSION_DEBUG        = BitShift(1, -6)
Global Const $CURL_VERSION_ASYNCHDNS    = BitShift(1, -7)
Global Const $CURL_VERSION_SPNEGO       = BitShift(1, -8)
Global Const $CURL_VERSION_LARGEFILE    = BitShift(1, -9)
Global Const $CURL_VERSION_IDN          = BitShift(1, -10)
Global Const $CURL_VERSION_SSPI         = BitShift(1, -11)
Global Const $CURL_VERSION_CONV         = BitShift(1, -12)
Global Const $CURL_VERSION_CURLDEBUG    = BitShift(1, -13)
Global Const $CURL_VERSION_TLSAUTH_SRP  = BitShift(1, -14)
Global Const $CURL_VERSION_NTLM_WB      = BitShift(1, -15)
Global Const $CURL_VERSION_HTTP2        = BitShift(1, -16)
Global Const $CURL_VERSION_GSSAPI       = BitShift(1, -17)
Global Const $CURL_VERSION_KERBEROS5    = BitShift(1, -18)
Global Const $CURL_VERSION_UNIX_SOCKETS = BitShift(1, -19)

Global Const $CURLPAUSE_RECV      = 1
Global Const $CURLPAUSE_RECV_CONT = 0
Global Const $CURLPAUSE_SEND      = BitShift(1, -2)
Global Const $CURLPAUSE_SEND_CONT = 0
Global Const $CURLPAUSE_ALL       = BitOR($CURLPAUSE_RECV, $CURLPAUSE_SEND)
Global Const $CURLPAUSE_CONT      = BitOR($CURLPAUSE_RECV_CONT, $CURLPAUSE_SEND_CONT)

Global Enum _
  $CURLM_CALL_MULTI_PERFORM = -1, _
  $CURLM_OK, _
  $CURLM_BAD_HANDLE, _
  $CURLM_BAD_EASY_HANDLE, _
  $CURLM_OUT_OF_MEMORY, _
  $CURLM_INTERNAL_ERROR, _
  $CURLM_BAD_SOCKET, _
  $CURLM_UNKNOWN_OPTION, _
  $CURLM_ADDED_ALREADY, _
  $CURLM_LAST

Global Const $CURLM_CALL_MULTI_SOCKET = $CURLM_CALL_MULTI_PERFORM

Global Enum _
  $CURLMSG_NONE, _
  $CURLMSG_DONE, _
  $CURLMSG_LAST

Global Const $CURL_WAIT_POLLIN  = 0x0001
Global Const $CURL_WAIT_POLLPRI = 0x0002
Global Const $CURL_WAIT_POLLOUT = 0x0004

Global Const $CURL_POLL_NONE   = 0
Global Const $CURL_POLL_IN     = 1
Global Const $CURL_POLL_OUT    = 2
Global Const $CURL_POLL_INOUT  = 3
Global Const $CURL_POLL_REMOVE = 4

Global Const $CURL_SOCKET_TIMEOUT = $CURL_SOCKET_BAD

Global Const $CURL_CSELECT_IN  = 0x01
Global Const $CURL_CSELECT_OUT = 0x02
Global Const $CURL_CSELECT_ERR = 0x04

Global Enum _
  $CURLMOPT_SOCKETFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 1, _
  $CURLMOPT_SOCKETDATA = $CURLOPTTYPE_OBJECTPOINT + 2, _
  $CURLMOPT_PIPELINING = $CURLOPTTYPE_LONG + 3, _
  $CURLMOPT_TIMERFUNCTION = $CURLOPTTYPE_FUNCTIONPOINT + 4, _
  $CURLMOPT_TIMERDATA = $CURLOPTTYPE_OBJECTPOINT + 5, _
  $CURLMOPT_MAXCONNECTS = $CURLOPTTYPE_LONG + 6, _
  $CURLMOPT_MAX_HOST_CONNECTIONS = $CURLOPTTYPE_LONG + 7, _
  $CURLMOPT_MAX_PIPELINE_LENGTH = $CURLOPTTYPE_LONG + 8, _
  $CURLMOPT_CONTENT_LENGTH_PENALTY_SIZE = $CURLOPTTYPE_OFF_T + 9, _
  $CURLMOPT_CHUNK_LENGTH_PENALTY_SIZE = $CURLOPTTYPE_OFF_T + 10, _
  $CURLMOPT_PIPELINING_SITE_BL = $CURLOPTTYPE_OBJECTPOINT + 11, _
  $CURLMOPT_PIPELINING_SERVER_BL = $CURLOPTTYPE_OBJECTPOINT + 12, _
  $CURLMOPT_MAX_TOTAL_CONNECTIONS = $CURLOPTTYPE_LONG + 13, _
  $CURLMOPT_LASTENTRY

Global Const $tagCURL_HTTPPOST = _
  "ptr next;" & _
  "ptr name;" & _
  "long namelength;" & _
  "ptr contents;" & _
  "long contentslength;" & _
  "ptr buffer;" & _
  "long bufferlength;" & _
  "ptr contenttype;" & _
  "ptr contentheader;" & _
  "ptr more;" & _
  "long flags;" & _
  "ptr showfilename;" & _
  "ptr userp; "

Global Const $tagCURL_FILEINFO = _
  "ptr filename;" & _
  "int filetype;" & _
  "uint_ptr time;" & _
  "uint perm;" & _
  "int uid;" & _
  "int gid;" & _
  "uint64 size;" & _
  "int hardlinks;" & _
  "struct;" & _
  "ptr strings_time;" & _
  "ptr strings_perm;" & _
  "ptr strings_user;" & _
  "ptr strings_group;" & _
  "ptr strings_target;" & _
  "endstruct;" & _
  "uint flags;" & _
  "ptr b_data;" & _
  "uint_ptr b_size;" & _
  "uint_ptr b_used;"

Global Const $tagCURL_SOCKADDR = _
  "int family;" & _
  "int socktype;" & _
  "int protocol;" & _
  "uint addrlen;" & _
  "ushort sa_family;" & _
  "char sa_data[14]"

Global Const $tagCURL_KHKEY = _
  "ptr key;" & _
  "uint_ptr len;" & _
  "int keytype;"

Global Const $tagCURL_FORMS = _
  "int option;" & _
  "ptr value;"

Global Const $tagCURL_SLIST = _
  "ptr data;" & _
  "ptr next;"

Global Const $tagCURL_CERTINFO = _
  "int num_of_certs;" & _
  "ptr certinfo;"

Global Const $tagCURL_TLSSESSIONINFO = _
  "int backend;" & _
  "ptr internals;"

Global Const $tagCURL_VERSION_INFO_DATA = _
  "int age;" & _
  "ptr version;" & _
  "uint version_num;" & _
  "ptr host;" & _
  "int features;" & _
  "ptr ssl_version;" & _
  "long ssl_version_num;" &  _
  "ptr libz_version;" & _
  "ptr protocols;" & _
  "ptr ares;" & _
  "int ares_num;" & _
  "ptr libidn;" & _
  "int iconv_ver_num;" & _
  "ptr libssh_version;"

Global Const $tagCURL_VERSION_INFO_DATA_EX = _
  "int age;" & _
  "char version[256];" & _
  "uint version_num;" & _
  "char host[256];" & _
  "int features;" & _
  "char ssl_version[256];" & _
  "long ssl_version_num;" &  _
  "char libz_version[256];" & _
  "char protocols[1024];" & _
  "char ares[256];" & _
  "int ares_num;" & _
  "char libidn[256];" & _
  "int iconv_ver_num;" & _
  "char libssh_version[256];"

Global Const $tagCURLMsg = _
  "int msg;" & _
  "ptr easy_handle;" & _
  "ptr data;"

Global Const $tagCURL_WAITFD = _
  "int_ptr fd;" & _
  "short events;" & _
  "short revents;"

Func __Curl_RuntimeLoader($ProcName = "")
	Static $SymbolList, $Dict

	If @AutoItX64 Then Exit MsgBox(16, "Curl", "AutoIt X64 Not Supported!")
	If Not IsDllStruct($SymbolList) Then
		Local $Code = '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' & _
			'AhZW1XBwlCIktpqktvcUKArA/HQc7Y2/o/9zreTY/2KBVWjJEV8vKlXuKUq7lNqPOkdLoTcoNCVm/Mto6PLgTmpTBYEiX1d7dE3vKiD8y03neTsXaD03om0KZUPmONRrz+87GF4CSUzv8lMFQ3OAineI7UC7nXT3EFwyXdHBvVJusry8qwNXEg0lLu3FdxdQ1SKBuXJFlt/LrtKriQD8B1FE7o9UM81vQIcwOa6Z/e39omYdAjsJ+u6uOvumM7ejPUpfdXx7oQXYSgu0JdifoN77SP5kVn8hheadmnrDrb4/dzFnJS4UYQgkykc3L+pH53MeMgjHcoXab6pFVyJv/qopleKlJ3W4g54awVrREZToIzHGTUDiCzZjD+sjPjN4Ut0U29hHSJYR1gON6U5x5ckJbND5yU9RDsodwn9klXgTLzRE8ON5mDDDTOAbNfl2bts0wc6j+HHMheoUL+w+qu4bgKwSv5pdyqGL1jAHxpnV/bTVTFbZhZuQdkXJuYWMNeKcbcPQtBF0K782vj7iCGfSGeaLONaUcIqw7aRbSyQjbMXovpj3TXyYfLP7zyFgK1OHqjdqgGgo2GGBuRmiIq8upSXoQ8mVgBj+a9lL0JMo/iYZw3rudBbOuIvgzLLpbKed0rEbMnzInKhg00yN7hi53KqTz0uJfRfqUrqzBNgFWo8o6+NHFtsmY0aeOQhRhRxTM+ckNhdwgYbmCfuKnSV8pgULCbvowkXiH9gU2reFOAIhaSC265KNPIFYM+wKotNumbt1eOFrBkTKz4Xkm5EjsBSB/pW9IzL8Bduih425uZh0vDmhNXZB9rXoHoyPReMHTgJDk9MuIeBcKDs20XnvAM/VYHTIFr/1Yg10gw9nOFK2wpNdGJapkXl8ZJObVN2ILMJ+T3fitCmzrz1LZVE2AFJusuZ7I1dqBL4F5fNxzRaFzQDS2xJWh11q7RFQgjNn0llIZ7vuAy/lRW0vxq1kQg6ghNKyF06Ev66Ct+xubs7mldJl6WXHw1ktv2iecwbxADzOd8I8o+s+54u5Qdbj8Ixl+fwqoi58jgEU7nTBdOs91yOpJZWvN0HUmpjyHS5Co6kIzCMirsXwT2RuAi7QVHOaiXGq+RcXOEPrvSp+iRqShfs9XsNo7PnZ7igyK151z9bqxMt8hP59sdawVkniue1MpmLx+v32+9tpXf7utvlLyJUUjMc7ESsrgQ2UEUrrTtfBbAVoIli8U4LsMysyqTAsqeEtYXLJ3si1Vj1BgMO3OF5b+kqhXWq5Gl5z+Yk9Wqilq8vHJPxIbflnUEdOYO8KH0WNHXs90y+beS91YOxpFpYfVmlg7srFCn2Zsb7M0zL1rGvVY31EH9qRmduKywQX7osdsoSLmIvkPcx7ltNcMGoM55Io8mjsn6p3GDccpBr8YM8K2m9l5zK9DWOE/2vrAtxr3sq8HYp6AcpXThOg7p8NkZUM+aqgSQG2gy24jhDY0dFgBWD9MIz+AmgUbh5k1dTwkT3exzCK5FLOs2vzAgaVNJzDnqEjCJkDkkU6iQJiBdMbyMMVF0SqSbiyBSIkcfRA5rodzJnVBPQKtkig/ntmZ63jKYq8OSi0qxH6JgnKl7j0a1a5CespQ0Nc3nmUQLlx6BOmwVmos5ZYCMMulS/f8KPtebcrh/b4KAk19hoBqFrIRkYqN3yVa7VMdhsIM6/sVr/+46t2lDASMsUKxSkLyskwhE/Br0TiGrhRlg25k6rwwo0BzzfILywYM8XODH7FDq7dUM2FPCmPG7Q5IxmtZTAWwDrx6n6n91BgxKnDBKXoYGbiTHz0amxvNPZXDkfbRaQsVZ/7RfwTRbGQAs7UIgvtM3EfVCt58/rJv4T3xyWLqhs6br4mh4D0ejEk4ZmXcoEGIbw61z6W6Plqlv1MrpagkKXteeD5Lm0DWPk38XukU3dZvYZdZTm9eXJeWDomSYNVdKCHkxe3aC4pzhcmvoW4NPHXtCayXh6g6Bgu3ONBeEqE2FJNJ3eMBFXLDv3xt550EHb+gIkofQ8eFfddrIeUlIlwS91e' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'7BnDTptS9FVWqW/YliJo9vSq/Roe7fE4JhR918xEmb4HEw3Om6yAN6mnsG+s1vrFt6YwT+tkIhdhMVUjNs0YzKg8XpOdnzTVpMDbiIDyU/UaKuKYq2ClQoVK+J1sp1d3iEiMzYU/JgbL8eXYs/qvaGWCgBd9ia4gHwG6fCeo9MEaYBPe9toih5vFyhoEXNmnZETl7GYM7Zrz6IuL61bdc3fwV7gBjVbEFs6LxDO56fQjr4vUPgWZbq4EjxLMyMsuxQgfCZjpdjZTSiCNCioizj7k2seh1yT8OmqlTynfMK34J6Niwqz/XM0oa9mTpiq7ah4eFBEOpQG5c2TjifiV+H7tV2Qpu3wGktz7eE3Gu7HEGymyKV7PKnDrEdiKVnHwqpojnNYdbtyyWkBr73BYoodHhqxnSGt5e1NHUl3t/1JCQLBckzLRS2B7z/SH/gz/Y+AikKM6dA3uA2Et5sN1b/dAPEWcdoZ3KwQKF+NcDhEPU8E/I/u7tQAyn53V8I0pczU9eR0Q+F69LI+CekkRfw8PsvKYp7+sSiAsrxrO4FYIKEpys3EzewTNUsVs8lnygc0VPy7WP9/zHdo85iQugsledoGz/wpJUjNNvxhdahY9Wi7ykchKW88Dv80FGah523EFZzdnbn3cc6dyBj1bC5qK+0YLQJ9YOiAhucqvLU0jAN53H3/1hKOHbLJaEQ8DCIqbWBGq7NJa3IOu5nrixbC9fEDR+hiLrtDQk/hWScyDJ5f2salB2t1cgVKlc7k5cQ0Z1Gg5Omo8lI/m3yDgPYT9ApJyP18aEC2u8QTahMRBGZZH6avxCYFcAJ1+LFmJxVJ2qFB2KhwYrQ30bWmdFoKewMUbAlzfKBGdcYxZ/sq/Y8AI/9SvZ0ROCfr7cGj1l+UQGavOOKdb1jdJtn/9YO5Rql85XLlzF2JLH+yZ+aQL/P6A9jsjDOxO87VC5A6BlTVkHkTViolGDiZ3M5DEJyBPxejfs8LtcO6dEHadnQRkVcujDFyc5s/bPp5yeIBD+B1oyKbhxB6m57r0FTpAaQ6yIzWypjgYiKk6P/5YE/b80b+DtGN8pD93UEQxB3Sb+4fskzUjWcDxSR4UwA0cEgLZxclvIz9cAUsABJkgl+cXq3DTm3N+bOhTFsimAEBV7J7++Kml8eO+/WG/ZV0MU24SKSMvLPtAJUA4C5WjUhCqR/YwORyGML16OTJKQwKc6s3kNqJWwxskFId97LALdM6SKpKioxdoILnINV8sLftM4qBikspQUOEdrJet0oLtqZNH7wr7j0IB5FsAXYImCkjzY3w+eSIdjyXj0NFF99iqusYUqejg7DANOkgtqMR+IGXWrywJqQqaU0NmMts3R1Ss8Hu+MlVhXiyUoqE9qqDtxMVVh5l9bkX7CuRGo6i2ixAEhtINvoJN/pCtW4jk6fONMmjxzVzMzd8StYbqaMqh1o4+6p6S1nssM+2OMtEQSRoueac5aO5LUKIEnvOGGDoxKxRyDh2bi/jvNLIzhOuD66mIaz0nhwWUzqAYt5YRribqkCvIk8kCnHqmvu0v8XJLb0wT+eHiMCT1o2hMnG/vFn06toHgOe7HvFsLcL+JGCB6E0mr3iZYhPBfbY9ruf2h8Nv8G/hLL8xfRg1cdJwtXK+zg+oHw3+lhg38JAcqZ6vqyPz6/ELfmQdt0rgEu8/31ahc4LllP7sr7yhRMHs/ULt+4U7OjmSXjXED53G1a6NOSYKT8xlD2J8SOrYZ88u7BybwILsiF6ETk7eBwZgwcXbSMVZ25CVJeaxvZsXQxppyZ4/cZv/9Ckd7VRdyZ8GQX3XgMXi+s0oFUdqYhL9Vl0DCeC1LwKZD5cPomMGxCSVGRk6eIp+XLIAW1QvtN99BIs6+OYdO5XA3HHtH4UHiD9kbLZP3i6OzlcoBrFcpCYO0dXYSlMBQPnDqXtJK5JprIcg9s0Wof396I4pfpP+8RO7IrkQZfbaS1IreS9h3FXeF71H7JI8FsU8qHeaPxAfUhIRnGKnGx+r3gD4dxYwdtoR3e1EghuGq6fiU/Dpq' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'Z3pLRoSicSyniSipVvy0onoCo1IIO9xVzPfseRmn49L8uV7JluRRHF7g0ZaB87TpFYwbfDx7QA6a3xl8FQaBPy3RoPn2hhVl+nJLXAKY789ltQuPflN9A2ghdR8J2imjR92+/+BE+jGq07sQd6AQYAh/blIPueJbNTqMcxnxRZBGTbMqjj4VFNBOmYMcA8fWds0En7f6ntSEOhGx/pWocaZAGvRq2JJnZ7S+YYdYLsyZTQxQg7xbXY47H2C/GylbpqYZfO+B4CLAXYL7yG9TEqo8oT1dhmtS/n2bPtny7eQHNpZlwtFtT4bT+ss7vNiHhbHk9gxAbSgORm6fwoolbyu/vNSNSUlx9A873G9uuPYBZsJSyvd38Nquq8NQbh9U5lmkIPd0vMtwA5vnXVxXsmn10TS+AmVMpLf+PqFN5I8WaeSKumRkzjdAO5xCypQBgHKNMR8wqzIjlOtb5YACyTP9bT0bsONVYkB7kRMAoXj/55kvAsSEqRIhknZd+zqAHeTEcsl+dQuzr4C+huVDCbUBMW7hpUDsFHAMFv1c9A7UY9+RKz1qjC8wWYRVHzwtmFtiSXVDwR8vnUfDAufb7EG1qfZtUEHTgsmVEsYRrWwoxR/MGpZ02y0Y0zVd4LBwVjYqdo3rgSUfeBesYw2c24l5BIPScpcmzftjvyF6u3RIgyPe10oUgvEKseB6h9o0bjPZk97THnMEG4j6u4EiMfzshicsXzdQ/EAhmU8u3cemyPTRgOXNi8zB4o7SyALwieKLFHQMbRtDJd3oi5KXmNEXOK6OYIeIUXTh2rrbPwF7+Gv9mkedjFr4utViaIBK4pGffmi4rxW8zfj9M0T8tfqz8PfQ3e5opCiRQV1YWlUljY7zt9RRTP5Iqcmnp+iCIHZlGmfLj570GirQwaWWW/Ctik+rhpRd0hjPFmffd5H20GO0jZmbBH5hJns62dkE9D2CcuFvqjrwiFN6jixCV/r0oJvSfVBu+Whc3QkJEWe2Jzqmvs4+C3DQq77jkmU1yNNJjjSS/9Z5CPg/tpVaOwYnjYoctyDZ6AxZ88f9LAtcWeuDIWDnCKrHX+Zcy0nng6EOt95ClVRM2TGl+ZbixJ7f+i3b+YA8TffoJwqI5RN1AmCLpA2G8J01D+ioWe3E2x58Yu+eOBI8xirj/OkneNiTOmCr0FIznRHhFPTF+qKdoillh+Pb+1EGlt1Sfv2oD86UYO0KWoB1I/0nmk0AJlgsHI5EJuxRu6qsBTjmELAXGG2L3vVQ6rZoZ0uw46GtXdJCEpczU4iKWDdRhF84cc2C6elq6m3PGe5Y4/EZ9y7f9o04ZjBu4p9WZXQfCyombPf+TbwxwMFf45WDklSyVVKNuZrDFpkuS+5euvwUpH9Hg6vtFDPYMTrmSMH4O8fS2/ec5fnu2OsoexgnqLzz85WYDX1Go085adJGpm6Ynacp8gEUvJ58AkBG2TDI9fHyK9wUI5M8nnn6bSRwlEAkx7MxYhpM3cUPqWiPur8jt4U5FjVFoRG6pHhCoXGfcsyDkSGF9zYPfIlUVF3LoZap8sq6bTgt5VoSn28fu2dvy3Dsr4+j7/0z+DL4+fuP8S2HTetCFHEQ0ZCm+p4YWiE/9h/2DAHhI/BfX39yLk85WnXLL+Dn/5KQpTGbL1R6IaYIq0v/htqHQ0221Wp9JwakVjA3EFTxD4YT1mlHGOMKfw/FHSn7uoYHVZioA8dEjuJzxC0B+3pktPhaHrX8agxo5GNwAOJx9vEaFBZ1TDDHVmbCoGxvlO4d12tDkmz/pndskJ8iuxdpCAmq2/x4USI+y0bUoG6ONTrQ5tncrqUeg7xqXtWWtAHKRGzA2ClLdtyqFuK0nT1i47SCShcj4f21CiE0QSVM1GBkOtkJWSXX2v5FG9sqtHz1b/nZnd7I4SRx+26eI7+4vB2VG6A43n1/T/6WfgUQBvkhY4/4dyB03YASkPKLJ3Gh6QISGz/z8z5JwXwCEfm26S/Krs39bYODV2cACd/oLS0mvaHnDJF4BK6x17Tk+NzMRzhrEOufSATy' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'hhu/J40N3eR2uPWkne8+4cPMuMVPjx30yvtrPPtwNW/P/LKBYowdt9QKombU5avrLUT/d6zbAI/QSIx4QSRNzZmgjn+LvxQeR4BiUmviFroRh8OXxFTSLCU9e9FSLAGPdRoq4olCBHSAqBCp5LbemPejkUKqPv9Z+iO7yWpXZ6s5sKq9AA4KBqZIvWNJAkwkwL0ebK9wLv0zI2B4WILW26ytU2sgjt642CZw2yurYcfKGDbZK2NnAju2ahSJma1d8rUmCbNsdwG5BOQCsnGHwPhJtZVri2KWx9zfQeJsT4W2p2pZamo96j/aQ9CqFD5f6X3bJ6p6xpUWudfwEw4+yvoXXh0u9D1SUM7CI3nhcFPBDImYxeKQCuqKdD5a/KT4o4dkuwyf0rfFfjc/aHqZ5BH5MCw10DV7g+r3+tDMjhH9EM0YjyXykW1h45NyvNbd8KOtOsfwe6DQyG02HoD7XOGIKlOJE2H30hMNn+bf7Zswe8AcNvpefddaLhKg2NfnguP1wgPcm0mNaZDXphf2AX46peVKAytJdXh2TGrKw2j3U7PmRuY5pfFEP6Xq+VO5i6Ol2HX4W79NfwD/L3PCwEdn2HYmFQFnZrO05BLt9ClLVWOBUXJhil77okckj/HBP2/D1z4YqiFOZAJF2q8Ms58OnCRk93C+xt4dC7r/51cU+WT0NMJHXyFcl77PxxymXJX/UC+u5X1LRpuNYDW30AAA+/YQQKgpHrVfCbT0sLqrDRy/oeTR4zuIlkzuBvuJQFynMg32M8XupfWUFFO2aiZU4FikwxCAcuuLeV4/rEAoCjFBmJjj0yL9IWmftm2o16Zitvb4qmCQ4O4kksVW8pBqN4jvCJZ0cEtcI1tVUHLiJ7ShRV74uUIxpSml97Syr15Wv+aMWnNbQLz+1ySiomQm762gv0rxsJPnD+N/USbawHM4IHD83gCMFXOQQUSDcNFer+rdqzx5Skp9roaCN8uJUH2BMm8gbHHwI1j1fjjGo2UGNAS0MDtKzZ6prPZQPvnWe5FKM+SsPbuSasG755vWFr5/zcoH09jarYSIPWydBpggJgh8v6gLmSyIoPLVnALVBqqMiACSZ7DhAPMeUVu/QzCqsirkgp9eD07KIYyoTIGMcDtDlsR5eyrU2hsOella5uDyEC+nuz/Wi13jObeZEMUe+YywennEmSe+GIK2mKSHWPi3nd1dr5kj5/7f1ykHMSVkAMGwOOUw5ptuCCay9fgayvKXPyZPlaZWrHP25kVrMrIShRmiBAP1GNWpmUlnIg5Ax112hXO3HueLU3eW5nptNwhLxAPmiOU87ZwcbMM1CrWSzAfPnEoPnqN3T34aoqres2Ix0JyJ/QY6W3QnZ8qfDmj2+LTWXnPPpIqUQoQMfDF2nFeqJHUmnNgeK/HsHCGF2gS+3YYJjE+wU0ly0o0kIDH/VtzJC4mEPskhcBG2ilxJakONW04QzCGastA/nf7xOiSI5xq/Z6zLstPYMvkdgotMsk2YJwtoNVWRrB+cT5KW/HoomIYmArlL+akAMtRdDvXclcVaePFeD57xiiQjMA2Yg4XBUvWtmlHq99Lu24TpwdRkbmTxVIemATr8S7Eka8RB3zbYEnMZTdT6Z/WOsXNM6PsFZCyGFfA0m3yGQPNjdRFSyO8J5OHFVV+UZ7WQrRAff08jPqE18XFEq6R8IODBySL0k2thCUZOI1hHbuT6mDBA4m0LdvAXqW8YNM5lC/wCxE4UHRtRKvuOPMnzPr2o0lBsXrXiNqmnt2tn6TT3TE2w0aHd1l+9KeaNQGa3P5IO2krgTseOc1s0IlpQGHeMCVo/o3dUet26FBpHqgyl3R+RCOJYu2Pt9C+zdewNgsoJjipSX4pkpNxEeTWxlxlMcuEqUBcX+GYTp72UgD9UaDYOyrfzBC9vl+ezfv1rkZnhMpXvr8nyjiB0VJP6/k1GVp3u7/4TIeC3TNXGg6YeKKv6yOoImKJIKRhQcsxWRRZLpr4ukET9XRNRxEmLOpA/kSv066zg0v/ptgzT/rq4paOkGf6Nvexd' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'0D0Ewuv/8ilwQ/JEcuOV5iahPxrzQTKrwAIA43K/tQl9bjTQb3JAZW8n7IUYQqGvNEtQdGTftZd6Mk0vF4lBAOth2WE8oixnM5BTbc57Z89Tm5K3M2BlfQMqO5z7/I5Df0TlHQqGXmdyPBarJj4l6IkcgwpzY7xZzEipb86HBzjHWweoM6s/MUynqqa6H54YaXcN49aRGpQ3hZwBI3rB0D12MQyoTb7JTx7PACz9VY8Mr7yDQC+kkwIWetP7tTH0a24/yRxE/OgcORMXpmt7Y2e7nc/v+1JZiMss5tUZwpnRdz0OijoK13VQYUc0oFXU1HGcX7YpKkZQLa8qI4qLhetwzQQn8nlYN1lyW/xTWmhKLHp8YFbSCRtbiSTVvzjBDZbT8lBKIyo1KzK/YwodIK/G61qymgS66q00B9XZOvi9Pe9uwAzO4WPLmQ+tG6ob/TVm68NRarM3OwK5gI3IFWgnLtkXxofuNVx+BkDmeUQ31bG/q0NAVYf734SeBdFi1tUYGdXHYvMmpSMhhswfgJbcUjvNeJl8c3ekKDWgz0uanIiPo8gdmEp76jAVXNPAd4aTYsFHHBYwtbNliZLaOU3PcNjP0HMZWAktCYRn0h63zRJw6JLNwg0BT5nQt1g0+y4OcCzbnI+VA4RpVCi0m+IrdsbBTb2+VPpLrLLLlisfFQvt65tRDN9ePou+6TyY40/LjvuJgXxWtWb7Cb4SWGmkXvJxVfn6ZF/xbMgoIMf7WA1kzJweA7hv/AVa077cDVgI22IJAEWQ64xEwidYS+O0gaPQ6lrIpbIqQbAj9a5ibUWeqGWcH0WXJt19Ie1rDAEgTGaxmHyPAsfYzkTAthb4glxy+M4HxxNelh4Qh6AJ/+RWxwHIc3SRGjPfa6n4oEzKuQEh1z2BKneyzQBBnkWPnoSrD8GhsFLfIwHC/OlMoi7KI+hOURn8qGjcP0H/bXWDZYQU6kUw1PhztVo0sFU1PIEDFnBT/nTzW0/kbzvCg6psrdMS5hTCTg2m2YoMuCEr4cmUt0Tf4AC8kqBy5H7q4MTHQ4EvSI8oQ93w7lpQsIl/fYdkr+C3st/yX/GYgZtQ3543vtZahd9gtGBa+r4BLGINu2dcTdJvb1l2z4oNz5GxwUGYwxLIrFYYgmmQIkMViacH+kAHQHnYemQVL8Z2IZut3KWCjQbIdEz1nK1nn7jwJTs7ZQS4bxOLjbj8tbFOufDBo3vpsAp+VrFCtjhdnCs6kmL585XcBy32c03yq28luwnwEk9e4t75b5kwUvB/XgGokSj9PBY5wktA1z57Yd0taNZKwMfGh0HdF0lkKqKrF2LjBdnvuQ81lygmv1BkxSJ8zHEMTAYIm0faaSDY+ZwSoKDYh40nN6SHoQcRuV0wVexvjozfFgwn+XYR3F+yWu571vQP1dcQWcYsl3WoOMta1Alf3yZeO5n74uBWHDlWp0nsw5XwuCKaPYamb1NbAXZ38N8+d5Aze/Z8b6yHz4+b5oVRemPe45OI7WEm8h6mQHUynx0N3pG3onolRgN0gJ/yw+XYH4ZaFSjlpsQrGonaxnKi7qDajHYDJYyBjqRpvwf5CYwZv6R06MVbJa4JveUZ/5CHW732TjSG6VqrCHWl4hYGq2wDya+jUj7xUhatocS//v9hqAmwkvlrbUEhzsNNWq2yKEEkcLep81cgHuN2K7mZRSsqsSuntv43tzMAWfvt3oVJ6nApol6GwiGdJ17NQj6zVW6jA55xDpJnZbRMnDpJ7tSJ1fzMz5zViBUAC0GdYHnzvgxf+OLeoyWWVCboQoJyU8iSHCn472xOyqnmfoeHfWCUpX1gI3FRs5rBXy5UADW7eGOsk4u6JwOjLJnbEVlvQsmcR5DYZ66ITUmHwzZHVkb+h7n+1AZTti5JUMjTKZXNzgZEh7b8RhQPH1fI2FzOGlXkmt4kVypgzvFIQjGB34aV33LGqN9rYdYKiWixxLGKpAK0JeHv7mqxV7EPJEGUH3VHvi8PbC639lM3z0e5dPv484gvMiaSpOUvSgPqlbAE4OoJSkcS' & _
			'gvjEbDynnhUhOO6OR1g72g/UWuV+j48h294OJQptjjnZ3tK6vFDiTvY9fFGvreDkHssI4IIe9q+rW8oBZ3Au8wYUnNgiMfLBwC6kZ9Ml/Y3ClxF4qxg2NirJCu+0o7V3ThtEqWY+CDaC/W5mTsRnpt00ZcFzA+URXDtFNnFRAfojJKuY6QYL9WVMmrd0J67Baw/3vB5Lp/JzcaPw2yNlVfouRLAjM3DTwD9WRikwkDHTRxofSNkHSBYxmKiqyJxeegQiA9sgpQJR8XTevyuHd9J0VZNL/r9HsiKcElw3t7ZXF3+LVHtli0rlk6S7VvLx7lrSPnLNZmMlCTmjGY0/EoDMq1NoTMaBxIBkyspJuwvvY2HJcpnXETiCKbakeXpWptrIAm48GH09KhbcQKXDgQCLcFAdWreOINa1oZDLjxsHe/u/i30+l4DeVkH8AEyAB6YC6mwBaWVVLTUZFVvoenyJERx91CeonG4oBQ+BYKuSkEaGj+TQ2n2J6oQHm4LB/KJCXTSj6cWH4d7MVDSTsFH5BQY3iBKke9nYTlGxPy9M34QYF0HMYFx0HpaoufFUhSIBMCsb/lllBn1aZgSkGNSk7Qegme85uESyRg0W4SDJPsbC/0hZkH8qTi2Aa4lCRbtUO7ppQQhKFvvL2jWyHAsTtcik8/7Lega7lzBZSbWzWi2Li64t0BB/eDruelqV1kjGQ0hnVjzQNqdKI9+Y0Mp76sOYkDT5J1IFWHnqiA0yQD/kqkvR9xBJv6CBppJn1z3cuRfRAkJe9UcOPCDIUWJj3FoA9Ll4J9NOTaOCEHuMd9y3jqHE3+oPE7YvtrKRDtCcpI5Re/Akq1L9Iz3db9K0xx72dtJT4GbMPbigx6IAWa+Dt4c6NQf1Z7i6wjmZfl4HFkwR63Y6mN8xSMAHxG+gw2jDns9hUlsuPK52+CgSuWXNhQ6w/x1Ws+SHhpbitb9u1n76dvp0AesO5SeGltG+3Dyu0wrsw9oa6T1Hnaf/1gSmjQu4r5MMpfrt/YfEfs6Kc4HcF5r2/0CrOoVjg16O/GOMgLBitFGmpK6oifSbGozWkkDsmLAX4hNqlQbZO04YOTHZrhs3whS7ak+6HmbTmHBPoPRydfLKMFdzvBgTsQoXaeIqAhHHKiyiAoRAA4ZeCVODbAEc3VD5dkwaKglxDy21t+C1NRMXRB+Vhf+oVRwceBCN6AJ2M41heB0sAdvwUSCv84on2eUJ9+aFsq3lOpY8f3yTQymnjzf004t5+6daV6WLokdJDZALGleKxd8OveSgW9Hkmt/nZFmStW91eNc0gD+Cic+MUEQeOkuO3IGGWVLTep5cifk8B5Uqdzo56n9/QJ0DmIRWBUl6zmwU+wpqj9H/O7cJLskY0di8ntpPbYCghiy42cGl1eNiyasHfPGqosvuJtiukb8Z+NeiiSIa/uBE0uMb7SOxGN2e9Aq3KsL1L4zd4TF0weG2zHrkxmRrP+uBN9hLV1lnh4Fx/cn8j1hNDfWcONqvTb3ue+JcdM9FcVCyhOefrJJyxNkODVjfwL2h3zL6mj+xwGRD/up1AH61FKJQaLNaZK3iKNs4ddRMwfL8qSUrSS1tzk/HP+soxQkWLxH5yHHXZNgISbOovX9wQi8h/YLIcRDQcZWAq/DBY9yjfd4pNm8i7szhRWMSAwt3VjQAwaW0mFQwBMorJ0YpkfQ8rPECFkQj78J9ffxE8tFwLh4t90pvz2LW1OoX2UIa+nPIpkbxtRfwmkZO8bDWPIoijdCHbE5VKW+6d15CpRjY09elUpWGPEHBI8+IL7UPLbtQh9RwjeI5boIj1WH5uxjEDeOtbaAGAiqJzBsWdfTOwrPMybqE5cBJNHphzYhZKRxZG4ae5CnQaZO6+BreALqP5b1xcTaa1F8JIYU+A4ARracQiPmW6YX6TcKKilwobZRSqbPlageJdIEvRr7NMnP9Sc8fvU4u7oWJFUQQz55d24Gn1ver4i6nqGBic3WFnUGySaN9wsRlK1O9e/BQ6uxov6VnMvCEuedAs0T6je7Ib//U8dlh' & _
			'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' & _
			'uzv9L4c56XY4S2mTsxSCi8JwASzJfsDuFYKO3B5JEAoCFvDZHr98Sq2zaIvoB3ZpJiAVzCjZvzqFKI7F6j72jxTEHX2Faxl+LK4Wko7zLlb3SO8WD7blypt9Zj5hJgtlLmveD/SwbFlBmJI4kALf1xBHIwmUY2GlKP38hRic1cDjFzrKFRo1Ux/EeLZ9p0ZwefUdmf5HRuyTmROnJ7k0bDWa73lqybotJfb9oNW0PhZYvC8DmPkG9JMx/gPjcaifo7CVQN0ZxCU4PcdNrE2YdEwUQAf8rcfToOR0QjASORiMikXF2zOb2Yg/8Fg8jr7KF4vuLfr/Feeg0/39He1vX5md8a2Qj4UDUD/76uSQTxQ/HY7Daz4B1manuh9LTYPyhwPEqxp+c3DWeFJzjkkowJpKi0upmqM+cY2CFZIuz7TLxrLP6aSQ9TELMqKb0qObmwkzrDZc6eSfAR4Yq6i4xxp7wR6ZKp8GCP7Hcf9/1Xu/uLpENm+n1wc2ihkIzD/WgKt2B3kpU5NCx3SO3htCNUVf54vjF+RGQ5J8tqFTehY9LQ8oP3FNkm5gcybZbYCQEwGi6NZfpUVNXVQDQbBLyBkU7MmCWii0c4my3vAD/cNO6BMnjUULkAuhycXzD2j1zwP0NcoeMNq7fYRldMHeHFtZYuZSiXHMtcyd7Es0phxJ7u3rgkuTje/f9i0lyC0rluYkVysV+AJqM94SF1SLQaRPEmY3rS6hRK1yDD0U0HyRKAb0StMO9s9cmrOGnO4uWl55n9teUYmpYYj97sGMQ5k2Awybb6wdp3GtNMkQcWorIyUxFotycLVsVpQljlrgEAEjEZG/TfZe2dUBukk15Rny9HJ5vo5BzNOvPGBOTySKfe3F47vUI90dRkH9qwGmD7LwIYxvKT4yMJDjClAZXACPLX4ok0OTNK7jlLU5KaT/cCp2zrAoQqFHZezE5qnW8qSpF3O6gHr+Eng/rDcyK9BVZy7PT8m+N7GtAoXRficRqw1KSRdPawoQB7U3vFYIu/nHzTyOWozVN5FyI4oAbybVDu8RWicGCfaz4k7rlPf0a3I4elpkfL0tN1CtpPVyX12fO38bx8lVIkFpfkQfEUPrvECLrufO6yNn39gxWnA782CdPeaET1rwRzjWaXm5Vw+CqZCoIfWldoShavGsPQAt4/OAhTzFd0wV4Q3cMT7+QS0hUH70Xd5wWB6r2t/aMDuoXPcVTx7unG29f7ncarKHPVjAYPw3rWjGTCWw7W51sOID5ZbrbV6un0LAWBTiE0Bg90fr7DwOziW5TqTUiiMgWsrv/uylTQ6cXyIvlDBB1yC8Dy9MRtzNrCGevBPIuMY5O4Fxf4gX0Gdc4Dtk7lOkfs3coosCpm6eN4LkAcrjcHoxMPQBdhgkq0rxVNnLL4J16Zo/BscIq8tVp/gYGQYQOUOkhFUBHktRs8qnQ6hdZxXlO4ffKb4fd/Kk2D8mNkOUaoew+agAz3+hc70UO/E9pAuJLfM5ESof4awP7Thbhg5q+6JCXl2RG6K0PP3hZv59riJqNgk5/04L+Kc8+k54XEwm7zgmSfdhBZJK8Hb60w5t0m5ZS1xaAmhteXrOTTYwKqgfiY1QmAPt4UcLavrckqeW6e4QMpLE3UcofKKLdYq8tvv0sC3FstLKLvAH8SCshYeOK2/jtLxReXn7V+3so+FcRLl600zo4dx4NETB4pBejX8ivzuIfyt5BoU1nyj+ePtnJGuajPFlSBFjrlY2D+9QThSS7Xjhw8ZNgmZ9oTuoLoXR1MndYBE0FVOrTlMspJEwPIJW56P4UwPW1YSwaengg8bFNqnOeOWldT9jqESVmlt+j0ONx8nrgLK9JgRhoQlQSw3P47RUr4LZPSEoK8g5DFfbVuHH16/I95DlEymnmovG7zXHhe2Ca5+hpLoa8dSDddcppExdQNn6yHQfZHic8UOOpd4tmvrbPFEzwhp54jI70BRT51fy6su6555Tn9o4jyTsW7gEiMOx2frsWyreH3GCO6FuSLScxOcIRdO9/+Io+ERlFPrxfruo' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'qd6xxLzSm2t3r7lNFARAsiJc+IAbmwgt6jgIQsl712q5+jlz7grgnHpbAUoFXI6gfhcCDkCNgBb9yr8XmgEiqjMC3yqb9aPz36P/gcfS3OnUppekCoLfRHhdHILYNwu02Yb9F+RYWv24tbCENZCxu5qmfLX4eUoZMffPKesidRK/PrNX8pe8p7G1oFkkrVdX1DpldfeaRZkCfp4OTHESpbmP1pXZneEn+ejfUDFDPX8xzE9ILCcaB7NqlUA7OHo9EVa9tWco9nDMSwrm77ZXld0c6eHGz9I3yQUcXkDuBn+HK75JLDzgtNx65HcXc4CthvQxi8DhML/eEj8U82pm/fKedzA+O2NJeqOMpJ4zIlr2pQIRJhQhLrWJjDJDw+mIKjc4MKgVz0jgJ4Ooz48kGrNHFrFgDvDvIbINeoGALX+VodetbVXCRLhINbR/gRhGPQkYnlDFJI32OoewWcElNWwqxDIpcdF+hTEKfL41vqbFObhEohaRW039GVr4FhE0g0N/1uuUc/fIEb18SonPLMLS+oRKjeGy4uJxmGeICftvIpXTlkASBTNf8JSWMdle61cpeZpERxVLiHn4unvFdksCyNBkozQ/sKNYbGQml9nph4NX/zWaXP1Gb/T1GPH4u5MGg8f01r3MGcH+HEiDawgpJWV2sQcAvbEzISb87/oyHSJ33xVpQ33tn1guyT5f8+sInxcMn6Z2iYRxL96lz7QcZRTikcVAuUIXnm7M88RKIuxcZxwNMMVTzk9hlDv6Gt4z1pRcHrEdlDatSrXgK/4EnUrMlVU/sPT2iaUd6RGTtJCV0PmgXfWiuRl69JyILSBiBlsGIdSpyflpuJVOB1BJeBDCY6GTdqfYQjMn7jns1QKVAWQV1q+XUcHvPYUJ0WPAbjAqiFB6ZWHoQYozlSAVXy7ylbhQjHdEcRIyQ9AHrycMU2gskqVg7HVrESAjjpJxcYw0Wwi8dJY6n+60znbmS4lyJsXNRBYCNOvDCv3YxcnBb3PZrJqsjfXEh6wXCb8nWBa/gg61ZdyAeSMbKrtemXBMa12HRX5rcExGgJWiZ3aO3EZR7FxloQDtCn1PjHvCJ++E8uxbIneqkc/hYHg0F7zqSaHxsBIKpccHHtM04gYljR0PpvFkpcvsoXKmzuZ09jEJBiAh4xFlZp05/Hsrsf52OIn7aBsidygVWMaHLCo/8xk1pRpUva5UHaFFggILjG14xW4WzUoO922FBqa7mM4u22uYH7Mc+ZXc8wugj2y4FyOfLJhJNhudprQ6N15rrJx/XxlcZ4sLOphFF+jBFf403pqp83cSNtiy3M52zih7QdrokiKXyao6DM0lJoQrmCs6Jsp10Al4w2wPg7XFOUYHVRECnUJLmMPzN0MbmIVz30GoW8/Ay28RJU+LbDP2MNcb+Zw3e6Lmi3vB/bnNZ/ha2zAnRPGdMdw9FN/G8HdbW4Z1oxXRED7Q1jzVo0VX3lBjmpSiAGIakgeyIxYmdVI38Fty3MguMl5pC6bgQPxv+zOu7QidbXGY+EMk+CqRsH12/D/wwJQtMbVGzetlMru3NntOvEzDXOjJg+9n9hAiuY8SoKFzaVrn7xYMQMxTs2EtyDkAgd1fxnwDDQUKKyS+Sjev6xFJKeoalaW00lUEwcXYw2/0TLIaTAFFO7UrU2rgKo8ZXweqaS/z/z7CQmsaO05nosnbk5oBPttqfOJotI1LOZwtC46VgtcSZ8oQNzK8YCXekJ/u/D70VXytqlSfDc3RtwewvtikEoREaZ56WJSiA0bre49ZdZYBTFsKtNflqHW5ZtS/Oahdwf/u7uwFOFQ/AMsaDhLHubJeiEkYRNY+AJuwV7BtziABcoN7Kn2zJwDT7WxfF8YHoJofMpjDrLmOkYvUDuBQA9mUsTgLo4nOPU/e6SkFmKKz0V3KPaVkEp3pHvFt43nMB5R46ZBm5IYShu6szrG1iX5ANkPx2P23h30TduKKk1Z65db+mJQWTL1I5NOzGYLxncpGH3ydVu/4wGJ/pyF9pHfIP+TmmeFmYAxhatXu6j3Y' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'utV59Bq4bkJZa6fTC7DVoP9I8t//4ezKP5eU7/gJaqzMqk6ffYddk04MqfVVZI5yhiK9/JWEfEtXzMuOk4flIgkvJ3AzLJpdO83VKmGKTib3p1Gy4tBAr5yFMqdDqffiH/pnnbgtifdlRZesk1WGo2z+3f0UfCkdrKv0QwQCcuBeOUbE62rayzfvnOUQMytPZkMn++raqWBl8l01mNPDpd77EoRDdvF+mMnnUo/9W7cYocn896WKYkyb1xGCc9J1u5P0V2t4rt/htzqLNmmsqK9gKOidXKI5YsdBHIOdfYqOGqU0WX9Q1uWayu++98VhWm+mXtMSdnajCvoQDDBTWFLNggfDmP8WRh4ZzKmZ1bBtSFpq0RW9wO5QyKK+V8VGzZeShHjC31QYJgP0URL3jV6IVWUHlOEZDJbGX4CrdBNahYdkHy64Y+rbJVgWpEQU+rVkHxZKzjzhYfFyxCnTdEzm3Va11jh23cA7mTa0yQW7TwyZ6RWailFGD4iteJXJ92XOU4QFb0aXmW/Jnf61v+GgirQN+bWoiPUpKetVU1XABT+ioRCnlRJqA/2xuChBZOSce8Z/FNZkr96rMrw8Ah6aMlvapG2DdD8cHsKX0ub3qCfTxwSWZwP+Fm1qjCTyYk16ACGjU2gnlIXcxhNmWAZ8FVdnXy0FYnsTIZBsOD/ZvMULWkFkim6kj5gX3qVniJJ7rME6rHTNktPIwrMWbQqjrwwE1eZJ5ybGaHIOtiF4mtS4NUmyIAaC9dGp9YaoPBvZvM6EDpQhIpFIFB8leQ1MKt7cfZlqYNEywVcnIq5xAvGWaXvMcyispWTkLxkeI4aic2uMNI2h03TgVjX6yGEia83xJs4GJIoNup/U7JiAfDqtKUm0rR0c11X8cOqTp5hArYk9V9RzFLoISrT9N4ZDdzAT0UR63nsKzps5JCj045SAg7XNyb4k7cerTdgArRpAEH5bNDpEQNk46ERWxqIeDNNsHw9POyu1gLqvtQGGTLFSKkDmMSVQ1JVJuJrf05m9LKh1G2r2e2SgzjlaxJ47HrR7onu6Lhu0piDlVmDip3biKloMgdzzFf3wYimbj9k6jeyYpeQRQIzqClY/az5rvIGF0tlWdqkQ1R93oC4YIt44cbUdMHC886a+01SaNB2wnxyiAK+GPrDqNKz2ozz6Dq645eoz9lXWRjC2UDZlmYD5YbJUeo9NHdR9QtySc7pmbMrmvJ8VS+yuJtSdZ6CJYj/gaXAuixduhRCWm3hrGHoCMUPC0Mn0UKrxkE7kWTlR0sl+jj7U0AtekyLJ3C3RFxra4geXw8oOb9kkgcJIuplkWHEaY2Li0OZJcEvAPZywmqEsj2OjGFgIf34i7gB9ilnq+bfUpKYI8oCp4ZMYBqrmvkjV3wnUMNehUz3jRniBWOSawqtSscZWvNn4RlGwKpS8sdrDZkDLYWBnCDf+4IMyr1hPeFDY5FG5wpaH/oXxRQggBoDVsNLe/iuUntzal/lYSl19Outh9SKjIrbs1xekr7m4nDsDH00QeHpC2h2u8/QI+aoWpMifQSMLNvUAY5XnUFP7UIrBuud4J6yhgACkJoQN3ahAiiJsGD6bLZZYW8eccRdZcDf3Zl8Lfljw0fkgjrhyMBcxLuvSJaQRPbHbNew/4RAPqaRpiuFuZOQIOTlFmn3UNQdxzoMaeHViP4uIUNQZhHGEQNNVRzIfAnGm+MiJWIAHhsIlaaZMsMttgi2uXkyJXem6DciqxZlVd7QH2ro5UhpYDE0/tH06MB4VMJy9pSBH1dRdxNB7vS/R0S9kPRmQzNsnCJFLKt8Uoib3uP+b+VHrk0KUhUe+tFje1k5Zkkov/wLbkFuyoZWKatCBlQpWzMJAxC5X4x88UckzhmHeIUQb9GWMmRcSlp//XUb68IfuL9XtTNYpuGftgrgGtlzwcxx7vLVUxdf2OM6OS/jvnPAKGkbo5sOagwRpalRyZmR64DP5g+JIqif7kE44S1TfrctSEj8rnMr+EX9kKUdvxZ5C1ipUYLd5xTHD3u3vWLRyy5BBrans' & _
			'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' & _
			'/OTj7QP9R1rRomYww+TClo6U85D8XCbvmU1yTHhBCixhoudItPTfXNC1blvMVV4aOAlAjw3AujwUP1bfS3G3xzUMqwpKcsedRpSE7kuNxXMYixKss5TSHW3pqMlSC58GpdUiOjj2yzZZ3rMuJ9Ck0qfzY8nRjaeXi0wqsoxklAYjgD7IYg70kOBehGa4zWWwkuZzYLj4olB80i/MgyXPn8dNj68xYExrFWFpQC5HxQuwT9Qh7Rx9E2LygYT8CPk/7VHk1WpaRFRkNeJQv4ghRDkLlYwcN8O2hzR8X4D9uG25d2iOrvAuMdHawOOY4ROUDpy70zmfPwya1DCcDGDIfmP2hs2scJQLYrK7yBhOSHbbf+ozsZ9UU2NaoOt3hE4N1hW6vCeCchFKLGjz75124rBnYJw69x9gOvAzJBA63SIqd9VpbSBDOWDGJaavg9r1W436fQKFgfHKomSJZ4pV4WEcrZ93KMVDSAViXYaAxoFFX79YGRlxNQaZx9oAZeitZnRbhIR0FApJ+7jKdb77+lRskn3zWy48bo1MTTC4X5yydCop3PiT7dUSzd/NlXkWl2sakXiSQcOcW/8mimy93ui+VbXZRmeBitvJX/QwQwiCM495ekoq+zafZFS0m5W91smeuEN1+AS5wpPRpHT1sxC4t5/693rRe9Lf6/8grk0Pfr3wma+50+H9N51nnOpj8FulXobyVnsnQS5sNFdpWH/iXmpsie68FOCm8eJ7jwlKjqOYSxd0JMPPducJyAkb2bX8QRAR9ZGvC+LQtXNnaivUvhPE6QjYnYJTc2KInCom851R1rBhy0ZvxHRLMTFmc1ZydDAL8+Rjj9oACONxG5Mss7sc8Tyh13nGT0+0i8QzBzKLA168BY0UQujMUFb1cKdnR/YKVySBcgXeUjmJC9objDhrvjcNnXyLuZPTuMSpwdH568Q+pUxIbWG31gngS7gDs71H/x+UxifLCt6lLoCQieqgi9KT8+uMAjx57HRT59XcZYAcn6d9U5rXWgqHO6yoBjRGqypCSfJT1odOfzlb8PpDMRvVX83slj4BrhlaxkpZ2RpMMI3qRmaXEO8nSxVFINkR9ieXC5mE92jF28E5igq1LVeb8Uq4azE7/xsgzNOQjqD2rYNrCf8KzC4SfZa8KSZ3TaK3Occvw3KA6/qz+ha2FYKTlz1+JBJJODjLsw5713g3tPxL9ZtctiIoOQA3dCFondOrdq0R72jU4gplZtIJttveq+mrakLdOROG8LUs8JsEXfih4zFOYittB4AIJe263752yjRfiWSJciIcYB/ogbOd5oK+odwGcDiD0ykIHD1V7LZLck+bUbzcRKPXCktR+tRVySa5zcDyBxt8oATt8rACFrYBPGc55w/2Ac7NZ6lEMtQMpvvZfI8vGlkXABUS9EoV7g49Ua5hUkjLQNSc9GGTKbAqHJj/Nm/kGbQYJU7D5+qZoqCmhitfdkwqFxr2MTMjOYbbbJKYbC4g2yc0pd/7ijX2c8uzm6az0fCc21hM8mocTqiaciW444mih7wd/9/+xRc1oIoqRIkrZo93+AK55JGcQtaEPctwWY/GQgHLrglgN3nl/GRBvcL2yedWFFYDa5fCJs7VPw/ZzBjws+FlOpOYezS9ehXnpZqK1a6+JI4h2sn0ptq/4S4XMvBeC1q7aRB78lmXcncRWiH/yvp/6z2uZyn81TWYu5Avsu0TOgUnJH5RFwACZYYKStnOtwngHAMCp7y/aSwTewJHGmA9/LhS+GzhUBSNe/1NPulrJ4XcDVnRuPQ44Y2iSaDoQgJOGWiHjVsGQNVMBeBxgR88V6PPaLZzdfyGjzGrVorbXINyfyDpS/VhRban43mvjiHH6Lx2vt/JkGqhQZkCXGrblThYPUW3ebbtMaXW3khY54D3a9pifmYkPbSxTb9EznIx5HD/vaAdyJhRHgX4ngSSeHljYl0gHAyQK43IsXkIlEKtLP0eVyoANP/SYw+8nYWfp3wOPfxULc/2pCdo9xbPGaB3SwV3mD9U7aYB67sFsPEpvT9O1/8V' & _
			'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' & _
			'V05LD2g2JgoHF9OlXCpUdSBkstgTIe3oudbKROEcAVa34aojS/tUSAocgwAXXrbDL0glsX2zIzuYz0XPhVA4+rGBpwrjJGPu7V49ga4/9ebpa3KnloCJk04otZgdhpfb+ZR8q00COseGiUt974Re70+egEAHnQaigdVlChTztbTCQmGfd1IPQXnKxy1kPq6+kqYas3gqR6Ykk5ffTrahkwNWMIavh2I4sNA/zIPcChW0ab1s7itxD1/JDXVg7aDknAPEgiL6P5MLNUKNUk9P8uDflkHOVdcwbKeHK5NFM9+DHEbsnrZ5xiLdEFWsg7IMYXpnnsbVg5TUBQ2BpTOswthCty0Iy1k3ZpMqyyVP2FcvW1kst0l0L6Rv4FP/IEVQECn0LSN99EfYfv+ILt+KGw1hNEQD7lzTI+ZEYOzVAaaKbYv+GUSO9SjVhcwCvCGHb5htlVxq99tEf5yV1JXjOD5xhPrTAFkMdyTG5Qn1J9I+dneIaCYDLDio3sy8Kprq8plh4ArToTyhSYZxRsJbkauMA/7lz1zkhan0NKmaKlm/i4GExTKAKUtVrft03IPdUn5TSnOXGpliJh+61wVgJlc5Al1kmeFphtoLsB+U20YNlvr9h90GvuU3MzAFjgTO0zTxC746xrnTBzVGUeCxeG7M4DfVNRigHWjr3jk1p52ZO97nPdtgGYCVRSfZnwNkHHrMtTLPvOfdb3qd0y4XOZSXz0M+keY6nDO1euy+8RsrC144Pl7Me2qmLyqm7djTTNTSLQTc3VIIDgzczbT1JVVdCDApuOZJ80Hcm3Z7L8f5tc/WCYzHcxI9q/vbPlSKcreNGmJ1xicg927fJbowp1mLbcPK280pLhfZvBKzgcL8AYh6WgzNmuMjt2JGwjbF6nJjD03nXT5W0HY+XekaFxJvYmhMin37EjjTzCrRF+UzONH70yIOnCU+cVJpboU/CkmybW5H7OWr4bd7Js4GugkvxgqXLOiAl0RhTZE4t3THu2wYWCC6PhqUFT8MjuRKEu8NnivXaIj2OkdE0oDzd2rXmSKCOW+tZpe8Ari2EGRe5sXD3DP7JwWJccvaAaHTVp1kVd8aAvYqiEmAjqDJ8ELzalcjdGUp5xbpEmAXKhBI+n/fGdufatZGha3UO2XS8XAVCiKV1wSCcMVuVI03/VqKvf7zi0X/8/Jjj+nMo01nuMsRU7ASl7avHeUxAtYomvuCk+UhjZNUvHqLuG0MLtbQlSu1MC37eqYb3hL4td1o0bhqq30BAyZMrnMIQv5EYTvVo6YWJSjH5Yoax06Fxwg2M9+D+j0e5ZFXIvB+nrhBcUjXVSRL6fWi5G7qOf/4pJEBbYC8aBCy9Xsr3XheAGpsJci1qimv67VLi3ViZyMygrzwiF+V8gLyt1wY3eI1hCVkywr2JWPQZadookINfSvCchf4V6zraRJRYYYfnTIjo/+WKmSh9IevsXVPRVumjL0nR0+cssDEnVisgr8Vbioqo1On0hI5Y48etBrdFR2DZXZpiWkenOdTuKzhB6umTrSfKT2iPg2+Ipuedekg52/SR/nRVs+I98sz4i8AZPArjdZxLniP1XCXLhZXol/LQV+VBkP+v1FOZii9iEbEkmK1uTI2cJQuB7Ks4GuG3k9wDEzc2VXOrI39LkTtxct6uGZBAoMG3MbZt1wq2TeJMp1fwzhpdQqI4zl27zMBsPShCD88MgIh184+mBsKLug6nP+OgW+g6QD7EkDUpDfIQ7pKCJLitOtggT23BAaC/UuWsbq2DRsfdwtJQHAqKISGS4SSydlbSSqZhg21SQbPbFRJIOKCUw6UwwJmrLtahAfDJ5m0n/qJccwgvdV6chde3mN/CXf4rR28+XFh8lrt5t2XaqatcgZI1UWRtbgnAnjEbNbd8qG0PwkVyIguK7QXsB/xOhVmTDbF3T5UgiwBUZknQxJE8FrvnZ5dtE7Up1kU1aE173vkX/XFQvXLqPpJv5HGvODuFRB8RkRVK8wiH5mhH1t7u5Z46VXtNgpUfocxOtJpAQUJOaIUT7Osouw7' & _
			'9ZzBL9btrZq45sCj/dgsAPB2l5eoJlWI++NEQqT7zQ6s85XvrpYwOW3p7H8RtZiSKhgdlW66IMOCsz8+ZkLKIQCT4zpGnAyDmRaFE2fGWyluNFb/j938s5nZCCFvHdctOyXSqMp2efqGqeLsL/SkW58zWFuPhiaPGf+ignq35Ca2r4FEy0DUkAY8sMNrn7BKclKt+aFeWOMKDZ3nBWu37cqSUHd0hJg9sl9NC+n0ROqvgwZlg4kWnFxlPDNmXbl3YUArI29GcJoyiJ7/sCtD0FDn/nQbuRxD+6EtEB0Qkb4kJT90Z28XT1Ik0pZu2CZdP5M+nhBJex2YR6yuw0pp1Dquxx75p0RHVJLK636upfME+XVawm4tc0ARjsdv3iSDr/sM64i+nLGytJ8pX6C6lgaWYdMZgfL08SeUZr4t+ToppGCmh6niNLOe0W/y4FS1LYXzszc1ot2fuighxMfe4BJ1OEYWYt3hhNr7noBwUHcZTeBW3Lg+FNPDDFWpXA5BPyzA0m1CaQjVEDt656lC+PAEl6TfVzYlFEnLiV+1MLVhW/qnL34C23oBLJgXIuGrOXjzeVtRJ2lD3u4uu/iLKfkiCCVw76CzC9ZH3UElEHFsAa9TMseVsaKGLjYhFbJcvgaU/RH4V1NXNYRCrZ+H4TJoGyuCwojXLYToellMDdpBLTa+cp1gXXUygEP50A1HrQUAi+mWvoG0mbCpaEtIjWdQXh8eVxwRhN4Vb0H9Np/Xfs+URXTxVgt5XuMPuWRzGENFVb+//4I+T80sBSUWPlikg7J/mRbiCTYvlkeDER08cznj1+6Ykzbo7fzsN330UK3Nab6XVUnFnL8jYU6rozWiJLVmKy1n7U9KDJGs5nc4ldCTWfdzG9oxpCoI7M2/LxAw1+C/vEqKMWE6W6ezYj8LilcpoN0Mo8ZJ3bFGomGvcuNAhvzrTvRaVlJ4iwstBT3TVs46tSgLj2atiB+xT+tiZPFRqOaxq/sqGqFLTU7L8wWTc/IkOeMm/yNmUx+8qtynzUmkHrufuwAsYQXrnx/0NcvSgL0XrrORTpntLgz8fsQlbNjRdr1U5rsciQJzDlB7To91B1rmM+rQn+pilSoMVIks4OjckZjzC26S0itGoq1E2NmdSon7g+i5G6d6H22ULv/1vUuDZ0t7TNN+TnXtavMjbMDM2DUTkQCN57YrpUOK7qjb0k0cRGyBHoRTMZiZ7vBGpm15FT2k/4tCu9btUZXGLUEpLKZlDTcMsypnBu6D0f9YJlsey1ActF02gIBctVTlIRO8XO9ndHNz4BiOE4pHXxUtVCWi1vTiNcwGzKN9KegFIW20DosVPW0c8J327+cC8WQYQjPtD45jb7vE5TTwvFOiYlbnrm2+xdhRSNlspUFgoysKUjtyXHihUobwRK4lJhUKhHZBm4zTZZLNcGV6NpBRv5afM6AITo6k8ImfCxUXC+l07JXDW8ymaP3Sd7uNNg9m25ciazA4hX+140N6BiXy7WWyW2uFRyxCC30p+XM69G+MkOK62lJlbnPYZYO+JGxsvnkDv6rJ93LIHgOds80fnRkRjN7kZFnDqT7Silqi+t6SeBQ6jsVc5XikXQ+5l5e9WilQdxdGuiZ0bkJDPLk7lKnyGJW+030ozG6luvTreFchaOkiKzJCo56y0yvpmK5me9w9eWhBzO7HK5DYUib06ZngPcWBEtobNsRCMe5EZOPxRYpLc5tWZB8C0T1z2LGsYH+uLDJP1ivC/iUPo+aM+uFMAUpu72xbGjiCXnxZiqBo+15KWzH+5t33Vqic2yVCLY8v43jcxrhbO0ayPpJj6o39foQwWuiQ/F2fL5O2MeQoPrFGnq6F3KZsbXji491kP7pepzs42Vgv/gZYX8vojqU5gj2OLvr76+Amnb1Mnw/ONkS+1hYCRVa8NSpx/iiml3kx1yR7I513zOIgnE7RQfkbcSdXc7B01A/DymkFXdI+5vgaD0iwEetBQrsU+IqdoloRGzhGxw9Y0s0vkKbBymqn6HaP4k2EgbP16Jo7Z+81xoWhqFDM' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'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' & _
			'dHEx6QEZGyI2kF7nylFq3iaIju0/vEupAWiJsZ7gVJG813SJ1MdHk9p6S8rlgtXdWl6gtdI1uo+hGnLyLFo2uO0YWgZv0v/bKuhDYmCHSfLxudHeiqxN0xbe5x1uPIeuzIm8icpcoKEClMgXlxAQdozu4ms0VUH3J4uljKU63LIz65ZIeJtTN94Rh738QgNv+sUnZhRs/s8d8C+q5o24oTGkIwmbR7iClCJlY8rTd39ocWb526UaHt0v62TYNVY2EcmnA+DMhKeSOtFEaQWuuYKTOywI2HJrUBbf2EYilidALtWWdD8A9HD8DF1cPDFmkY+6FJEy2La3lTnQbjZVacE4KPbdzcd386VJ8ffuE8Gh0DLBhgWO5o+Y4JYzMKtk/q1/pSBWniVbRwTxY0BeZUR/w1xEaHSijD1NgFFbVkV9LpsDRuwYIlU2Va5kHEPLVZewUHpGfr9mkOc6H1d6T2xAi9sdFppUKdZK40z3m6zyTU0ndS24KBvQnoIM4ZWA76fo4i5NZ25RON9oZ4xV9utfeYf2fvoZB61QplDfndsROrjimXBHeY9vnP0YFKeTtuTXC+YfUWbUxDJt6bihsYHMmrTJFSWjjioH+MXHcVDg1ATGEvzlng5ZPtu0g5Jn6RQDj+Kgd/+xkCvgnLh7mh24Aj3b/dZMTAKOQQl7nMZdsp2AxDttllmDd6LX4GnksxUGP7hy7yPo2ilDsViH0h2heRd7htX21T7VWsTcMZmPO4UoKmprdT1Wno/LEJZ6MYkVrlUz80TQy/9M8ldHFE6IHgG3lMtUdPwPaoUJJz3DwPzORwKBh6XkTWXUa2nZb+8YU2XTDm5Q0RrB4NQ3cPpYf5G6lsNLIGD+kVTEjR5nbBL2u8loFM64VV+5qCpSzVSn5SC1SlDh9c/TmqhfsV3f6yGoIUrrpIkSBy8Di06RisIkVeVRVgPAv9eQ2wHMIFcVBwSfoH+y/bkZNinSOTwfyuLxNfi0HZVGoXjNEnF5S3fn49M+ST26pnc+fwAp87MQRPtBILY0NzMjgGTWJZ3MKr2Un2QtlIGIP0eGbHmi+1WTVkCXBJFGHrYjNxtXmfqFPd4w5XS1FqNzl/eY+Hj0ql4Zytf85bhFpgoAD2i15HDEnYsclsKlVsj7c3eNia1UFXIYdXuAx8i0HXeOqfJ4zra4JP6DkQCDESjLzzRKzCbUMrgBOqXOI0xO2KSOx/CoZ1iJDMzgufYzDmadBt4ZsP/6JCZ+QO6syOr3zOvU2lsd3AU/8rQAnHQ8OLdoUa4hCDmatj9DjnBn1SGB4q6M8817Tw/iD8ErgZmpIE8h7PhrvDYCNypnwiCn+GWWFWpYtdd4M9Ol'
		Local $Reloc = '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' & _
			'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' & _
			'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' & _
			'npX/MPk24wacbZZOezdSVc9DKwckOEGAfD85LfcqTirS4kQhf5EZc46HcyyXo0NJnEFt85mtFb8nbXJzK0cdtzQA4IflCvKoqvUVCtVuyUqw4CJMXMJapUymw8Qv84TprvA8e6lKJ1KoFrbyGXiS4WmSItTfZfgL47HURohSNA1SFUhow8+7kGfI1LRRJfwGFEjOR1qVlY6Dca38GsE0gllaIro5zq2wrBUZor6E9lt/uGFeOwy3jJ844LQ/FKo3Kr0xy33V66OY//Jnqej2S/Mg24XSCxTBjYpRIjvWohxK/gwsU6BGPmJTdyV8mQH3DAGdmbfF2TGKjnRWF0s+HVRQRoGTirF092VM8wF2Q8Nw9i/tq0D0ET+T1zBsbEraraywp9yAYRAhhBlJDwApNXJN3czYYYtzDC0s+2/rI1mkkh5sxn1Qso9yD8oQanpc0I4pd83VvgDVAQj2E1GUNG3ttkn+q24aCEHXSzSYfpVXnXq0wNN5/xICulugpGOfIkoCb6yV6VXRi7WgqAi5YV4LhIspcGLrRjBE9D/YrL57jGMfXCnZ9cmM9+2U6dQAvLviVn8u3yADsQigNuJt7ajwV68c/4Pj66/kwDXneoBM8N/RgUDbUQHScI9f3Z/afWBcG3clA/GS/GX/Cc1O/DxJEjh7IwWqYmSFIZ7j1NNGWhGQYLWIwm4jwcEi2vd4T0RsJrwqdQixwaX9CuWsuWxhcwgqexPWZoEF85ZG1vPLFV1zstnCiVLe8dA4TgHhKOulUQdkf42MmcATnF6bCSDyikwx7Ekg/A9sY8tS1YRZaygOuZCS5n7p5xWCkAG1rcpcwqvVECLzGu/lAQCZfIVUiDENG6De2Wg7HqOeUC8kf20FUnKrQ/n/ed8pkau20DOqXX1aD7v2WErThBEYvAY6rMCLFO7HofUD4EV4qcYZyrRKczqjJoUYi1a+tkKHQjThwE5UsB2rpllZ3acoDLv38P/3lEatX17y9PeFU/lDTHzBNzZOe8yFTS4DNYCkc7jkio8DEvh4lIN8b7RIeRLNqb1nElWxTJgI9+DMS+88'

		Local $CodeBase = _BinaryCall_Create($Code, $Reloc)
		If @Error Then Exit MsgBox(16, "Curl", "Startup Failure!")

		Local $Symbol[] = ["curl_easy_cleanup","curl_easy_duphandle","curl_easy_escape","curl_easy_getinfo","curl_easy_init","curl_easy_pause","curl_easy_perform","curl_easy_recv","curl_easy_reset","curl_easy_send","curl_easy_setopt","curl_easy_strerror","curl_easy_unescape","curl_formadd","curl_formfree","curl_formget","curl_free","curl_getdate","curl_global_cleanup","curl_global_init","curl_global_init_mem","curl_multi_add_handle","curl_multi_assign","curl_multi_cleanup","curl_multi_fdset","curl_multi_info_read","curl_multi_init","curl_multi_perform","curl_multi_remove_handle","curl_multi_setopt","curl_multi_socket","curl_multi_socket_action","curl_multi_socket_all","curl_multi_strerror","curl_multi_timeout","curl_multi_wait","curl_share_cleanup","curl_share_init","curl_share_setopt","curl_share_strerror","curl_slist_append","curl_slist_free_all","curl_version","curl_version_info"]
		$SymbolList = _BinaryCall_SymbolList($CodeBase, $Symbol)
		If @Error Then Exit MsgBox(16, "Curl", "Startup Failure!")

		$Dict = ObjCreate('Scripting.Dictionary')
		$Dict.CompareMode = 0
	EndIf
	If $ProcName = "dict" Then Return $Dict
	If $ProcName Then Return DllStructGetData($SymbolList, $ProcName)
EndFunc

Func __Curl_lstrlenA($Ptr)
	Local $Ret = DllCall($__BinaryCall_Kernel32dll, "int", "lstrlenA", "ptr", $Ptr)
	If @Error Then Return SetError(1, @Error, 0)
	Return $Ret[0]
EndFunc

Func __Curl_lstrlenW($Ptr)
	Local $Ret = DllCall($__BinaryCall_Kernel32dll, "int", "lstrlenW", "ptr", $Ptr)
	If @Error Then Return SetError(1, @Error, 0)
	Return $Ret[0]
EndFunc

Func __Curl_Peek($Type, $Ptr)
	If $Type = "str" Then
		$Type = "char[" & __Curl_lstrlenA($Ptr) & "]"
	ElseIf $Type = "wstr" Then
		$Type = "wchar[" & __Curl_lstrlenW($Ptr) & "]"
	EndIf
	Return DllStructGetData(DllStructCreate($Type, $Ptr), 1)
EndFunc

Func __Curl_Poke($Type, $Ptr, $Value)
	If $Type = "str" Then
		$Type = "char[" & (StringLen($Value) + 1) & "]"
	ElseIf $Type = "wstr" Then
		$Type = "wchar[" & (StringLen($Value) + 1) & "]"
	EndIf
	DllStructSetData(DllStructCreate($Type, $Ptr), 1, $Value)
EndFunc

Func __Curl_DictPut(ByRef $Dict, $Key, $Value)
	$Key = String($Key)
	If $Dict.Exists($Key) Then $Dict.Remove($Key)
	$Dict.Add($Key, $Value)
EndFunc

Func __Curl_DictGet(ByRef $Dict, $Key)
	$Key = String($Key)
	If $Dict.Exists($Key) Then Return $Dict.Item($Key)
	Return SetError(1, 0, '')
EndFunc

Func __Curl_DictDelete(ByRef $Dict, $Key)
	$Key = String($Key)
	If $Dict.Exists($Key) Then $Dict.Remove($Key)
EndFunc

Func __Curl_DataWriteCallback($Ptr, $Size, $Nmemb, $Handle)
	Local $Length = $Size * $Nmemb
	Local $Data = __Curl_Peek("byte[" & $Length & "]", $Ptr)

	Local $Dict = __Curl_RuntimeLoader("dict")
	Local $Old = __Curl_DictGet($Dict, $Handle)
	__Curl_DictPut($Dict, $Handle, $Old ? $Old & $Data : $Data)

	Return $Length
EndFunc

Func __Curl_DataReadCallback($Ptr, $Size, $Nmemb, $Handle)
	Local $Length = $Size * $Nmemb
	If $Length = 0 Then Return 0

	Local $Dict = __Curl_RuntimeLoader("dict")
	Local $Data = __Curl_DictGet($Dict, $Handle)

	Local $DataRead = BinaryMid($Data, 1, $Length)
	__Curl_DictPut($Dict, $Handle, BinaryMid($Data, $Length + 1))

	__Curl_Poke("byte[" & $Length & "]", $Ptr, $DataRead)
	Return BinaryLen($DataRead)
EndFunc

Func __Curl_FileWriteCallback($Ptr, $Size, $Nmemb, $Handle)
	Local $Length = $Size * $Nmemb
	Local $Data = __Curl_Peek("byte[" & $Length & "]", $Ptr)

	FileWrite(Int($Handle), $Data)
	Return $Length
EndFunc

Func __Curl_FileReadCallback($Ptr, $Size, $Nmemb, $Handle)
	Local $Length = $Size * $Nmemb
	If $Length = 0 Then Return 0

	Local $DataRead = FileRead(Int($Handle), $Length)
	If IsString($DataRead) Then
		$DataRead = BinaryMid(StringToBinary($DataRead, 4), 1, $Length)
	EndIf

	__Curl_Poke("byte[" & $Length & "]", $Ptr, $DataRead)
	Return BinaryLen($DataRead)
EndFunc

; ============================================================================================================================
; Curl Global Functions
; ============================================================================================================================

Func Curl_Escape($String, $Encode = 1)
	If $Encode = "ansi" Then $Encode = 1
	If $Encode = "utf16le" Then $Encode = 2
	If $Encode = "utf16be" Then $Encode = 3
	If $Encode = "utf8" Then $Encode = 4
	Return Curl_Easy_Escape(0, $String, $Encode)
EndFunc

Func Curl_Unescape($String, $Encode = 1)
	If $Encode = "ansi" Then $Encode = 1
	If $Encode = "utf16le" Then $Encode = 2
	If $Encode = "utf16be" Then $Encode = 3
	If $Encode = "utf8" Then $Encode = 4
	Return Curl_Easy_Unescape(0, $String, $Encode)
EndFunc

Func Curl_FormAdd(ByRef $FirstItem, ByRef $LastItem, $Option1, $Value1, $Option2, $Value2 = 0, $Option3 = 0, $Value3 = 0, $Option4 = 0, $Value4 = 0, $Option5 = 0, $Value5 = 0, $Option6 = 0, $Value6 = 0, $Option7 = 0, $Value7 = 0, $Option8 = 0, $Value8 = 0, $Option9 = 0, $Value9 = 0, $Option10 = 0, $Value10 = 0, $Option11 = 0, $Value11 = 0, $Option12 = 0, $Value12 = 0, $Option13 = 0, $Value13 = 0, $Option14 = 0, $Value14 = 0, $Option15 = 0, $Value15 = 0, $Option16 = 0, $Value16 = 0, $Option17 = 0, $Value17 = 0, $Option18 = 0, $Value18 = 0, $Option19 = 0, $Value19 = 0, $Option20 = 0, $Value20 = 0)
	Static $curl_formadd = __Curl_RuntimeLoader("curl_formadd")
	If Mod(@NumParams, 2) <> 1 Then Return $CURL_FORMADD_INCOMPLETE

	Local $Script = 'DllCallAddress("int:cdecl", $curl_formadd, "ptr*", $FirstItem, "ptr*", $LastItem'
	For $i = 1 To (@NumParams - 3) / 2
		$Script &= ', "int", $Option'& $i
		If IsString(Eval("Value" & $i)) Then
			$Script &= ', "str", $Value' & $i
		Else
			$Script &= ', "int", $Value' & $i
		EndIf
	Next
	$Script &= ', "int", $Option' & $i & ')'
	Local $Ret = Execute($Script)
	If @Error Then Return $CURL_FORMADD_INCOMPLETE

	$FirstItem = $Ret[1]
	$LastItem = $Ret[2]
	Return $Ret[0]
EndFunc

Func Curl_FormFree($FirstItem)
	Static $curl_formfree = __Curl_RuntimeLoader("curl_formfree")
	DllCallAddress("none:cdecl", $curl_formfree, "ptr", $FirstItem)
EndFunc

Func Curl_Free($Ptr)
	Static $curl_free = __Curl_RuntimeLoader("curl_free")
	DllCallAddress("none:cdecl", $curl_free, "ptr", $Ptr)
EndFunc

Func Curl_GetDate($DateString, $Now = 0)
	Static $curl_getdate = __Curl_RuntimeLoader("curl_getdate")
	Return DllCallAddress("int:cdecl", $curl_getdate, "str", $DateString, "int", $Now)[0]
EndFunc

Func Curl_Global_Cleanup($Flag)
	Static $curl_global_cleanup = __Curl_RuntimeLoader("curl_global_cleanup")
	DllCallAddress("none:cdecl", $curl_global_cleanup)
EndFunc

Func Curl_Global_Init($Flag)
	Static $curl_global_init = __Curl_RuntimeLoader("curl_global_init")
	Return DllCallAddress("int:cdecl", $curl_global_init, "int", $Flag)[0]
EndFunc

Func Curl_Global_Init_Mem($Flag, $MallocCB, $FreeCB, $ReallocCB, $StrdupCB, $CallocCB)
	Static $curl_global_init_mem = __Curl_RuntimeLoader("curl_global_init_mem")
	Return DllCallAddress("int:cdecl", $curl_global_init_mem, "int", $Flag, "ptr", $MallocCB, "ptr", $FreeCB, "ptr", $ReallocCB, "ptr", $StrdupCB, "ptr", $CallocCB)[0]
EndFunc

Func Curl_Slist_Append($List, $String = "", $AutoSplit = False)
	Static $curl_slist_append = __Curl_RuntimeLoader("curl_slist_append")

	If $AutoSplit Then
		Local $Split = StringSplit($String, @LF, 2)
		For $i = 0 To UBound($Split) - 1
			$List = DllCallAddress("ptr:cdecl", $curl_slist_append, "ptr", $List, "str", StringStripWS($Split[$i], 3))[0]
		Next
		Return $List
	Else
		Return DllCallAddress("ptr:cdecl", $curl_slist_append, "ptr", $List, "str", $String)[0]
	EndIf
EndFunc

Func Curl_Slist_Free_All($List)
	Static $curl_slist_free_all = __Curl_RuntimeLoader("curl_slist_free_all")
	DllCallAddress("none:cdecl", $curl_slist_free_all, "ptr", $List)
EndFunc

Func Curl_Version()
	Static $curl_version = __Curl_RuntimeLoader("curl_version")
	Return DllCallAddress("str:cdecl", $curl_version)[0]
EndFunc

Func Curl_Version_Info($Type = $CURLVERSION_NOW, $Parse = True)
	Static $SizeOfPtr = DllStructGetSize(DllStructCreate("ptr"))
	Static $curl_version_info = __Curl_RuntimeLoader("curl_version_info")
	Local $Info = DllStructCreate($tagCURL_VERSION_INFO_DATA, DllCallAddress("ptr:cdecl", $curl_version_info, "int", $Type)[0])
	If Not $Parse Then Return $Info

	Local $InfoEx = DllStructCreate($tagCURL_VERSION_INFO_DATA_EX)
	DllStructSetData($InfoEx, "age", DllStructGetData($Info, "age"))
	DllStructSetData($InfoEx, "version", __Curl_Peek("str", DllStructGetData($Info, "version")))
	DllStructSetData($InfoEx, "version_num", DllStructGetData($Info, "version_num"))
	DllStructSetData($InfoEx, "host", __Curl_Peek("str", DllStructGetData($Info, "host")))
	DllStructSetData($InfoEx, "features", DllStructGetData($Info, "features"))
	DllStructSetData($InfoEx, "ssl_version", __Curl_Peek("str", DllStructGetData($Info, "ssl_version")))
	DllStructSetData($InfoEx, "ssl_version_num", DllStructGetData($Info, "ssl_version_num"))
	DllStructSetData($InfoEx, "libz_version", __Curl_Peek("str", DllStructGetData($Info, "libz_version")))
	DllStructSetData($InfoEx, "ares", __Curl_Peek("str", DllStructGetData($Info, "ares")))
	DllStructSetData($InfoEx, "ares_num", DllStructGetData($Info, "ares_num"))
	DllStructSetData($InfoEx, "libidn", __Curl_Peek("str", DllStructGetData($Info, "libidn")))
	DllStructSetData($InfoEx, "iconv_ver_num", DllStructGetData($Info, "iconv_ver_num"))
	DllStructSetData($InfoEx, "libssh_version", __Curl_Peek("str", DllStructGetData($Info, "libssh_version")))

	Local $Protocols = ""
	Local $Ptr = DllStructGetData($Info, "protocols")
	While 1
		Local $Pstr = __Curl_Peek("ptr", $Ptr)
		If Not $Pstr Then ExitLoop

		If $Protocols Then $Protocols &= ","
		$Protocols &= __Curl_Peek("str", $Pstr)
		$Ptr += $SizeOfPtr
	WEnd
	DllStructSetData($InfoEx, "protocols", $Protocols)

	Return $InfoEx
EndFunc

; ============================================================================================================================
; Easy Interface Functions
; ============================================================================================================================

Func Curl_Easy_Escape($Handle, $String, $Encode = 1)
	Static $curl_easy_escape = __Curl_RuntimeLoader("curl_easy_escape")

	If $Encode < 1 Or $Encode > 4 Then $Encode = 1
	Local $Binary = StringToBinary($String, $Encode) ; allow Chr(0)
	If Not BinaryLen($Binary) Then Return ""

	Local $Buffer = DllStructCreate("byte[" & BinaryLen($Binary) & "]")
	DllStructSetData($Buffer, 1, $Binary)
	Local $Ptr = DllCallAddress("ptr:cdecl", $curl_easy_escape, "ptr", $Handle, "ptr", DllStructGetPtr($Buffer), "int", BinaryLen($Binary))[0]
	Local $Ret = __Curl_Peek("str", $Ptr)
	Curl_Free($Ptr)
	Return $Ret
EndFunc

Func Curl_Easy_Init()
	Static $curl_easy_init = __Curl_RuntimeLoader("curl_easy_init")
	Return DllCallAddress("ptr:cdecl", $curl_easy_init)[0]
EndFunc

Func Curl_Easy_Cleanup($Handle)
	Static $curl_easy_cleanup = __Curl_RuntimeLoader("curl_easy_cleanup")
	DllCallAddress("none:cdecl", $curl_easy_cleanup, "ptr", $Handle)
EndFunc

Func Curl_Easy_DupHandle($Handle)
	Static $curl_easy_duphandle = __Curl_RuntimeLoader("curl_easy_duphandle")
	Return DllCallAddress("ptr:cdecl", $curl_easy_duphandle, "ptr", $Handle)[0]
EndFunc

Func Curl_Easy_GetInfo($Handle, $Info)
	Static $curl_easy_getinfo = __Curl_RuntimeLoader("curl_easy_getinfo")
	Local $Type = 'ptr*', $IsString = False
	If $Info >= $CURLINFO_STRING And $Info < $CURLINFO_LONG Then $IsString = True
	If $Info >= $CURLINFO_LONG And $Info < $CURLINFO_DOUBLE Then $Type = 'long*'
	If $Info >= $CURLINFO_DOUBLE And $Info < $CURLINFO_SLIST Then $Type = 'double*'

	Local $Ret = DllCallAddress("int:cdecl", $curl_easy_getinfo, "ptr", $Handle, "uint", $Info, $Type, 0)[3]
	Return $IsString ? ($Ret ? __Curl_Peek("str", $Ret) : Null) : $Ret
EndFunc

Func Curl_Easy_Pause($Handle, $BitMask = $CURLPAUSE_ALL)
	Static $curl_easy_pause = __Curl_RuntimeLoader("curl_easy_pause")
	Return DllCallAddress("int:cdecl", $curl_easy_pause, "ptr", $Handle, "int", $BitMask)[0]
EndFunc

Func Curl_Easy_Perform($Handle)
	Static $curl_easy_perform = __Curl_RuntimeLoader("curl_easy_perform")
	Return DllCallAddress("int:cdecl", $curl_easy_perform, "ptr", $Handle)[0]
EndFunc

Func Curl_Easy_Recv($Handle, $BufferLen = 65536)
	Static $curl_easy_recv = __Curl_RuntimeLoader("curl_easy_recv")

	If $BufferLen < 1 Then $BufferLen = 1
	Local $Buffer = DllStructCreate("byte[" & $BufferLen & "]")
	Local $Ret = DllCallAddress("int:cdecl", $curl_easy_recv, "ptr", $Handle, "ptr", DllStructGetPtr($Buffer), "uint_ptr", $BufferLen, "uint_ptr*", 0)
	Local $RecvLen = $Ret[4]
	Return SetExtended($Ret[0], BinaryMid(DllStructGetData($Buffer, 1), 1, $RecvLen))
EndFunc

Func Curl_Easy_Reset($Handle)
	Static $curl_easy_reset = __Curl_RuntimeLoader("curl_easy_reset")
	DllCallAddress("none:cdecl", $curl_easy_reset, "ptr", $Handle)
EndFunc

Func Curl_Easy_Send($Handle, $Data)
	Static $curl_easy_send = __Curl_RuntimeLoader("curl_easy_send")

	$Data = Binary($Data)
	Local $DataLen = BinaryLen($Data)
	Local $Buffer = DllStructCreate("byte[" & $DataLen & "]")
	DllStructSetData($Buffer, 1, $Data)

	Local $Ret = DllCallAddress("int:cdecl", $curl_easy_send, "ptr", $Handle, "ptr", DllStructGetPtr($Buffer), "uint_ptr", $DataLen, "uint_ptr*", 0)
	Local $SendLen = $Ret[4]
	Return SetExtended($Ret[0], $SendLen)
EndFunc

Func Curl_Easy_Setopt($Handle, $Option, $Value)
	Static $curl_easy_setopt = __Curl_RuntimeLoader("curl_easy_setopt")
	Return DllCallAddress("int:cdecl", $curl_easy_setopt, "ptr", $Handle, "int", $Option, IsString($Value) ? "str" : "ptr", $Value)[0]
EndFunc

Func Curl_Easy_StrError($ErrorNum)
	Static $curl_easy_strerror = __Curl_RuntimeLoader("curl_easy_strerror")
	Return DllCallAddress("str:cdecl", $curl_easy_strerror, "int", $ErrorNum)[0]
EndFunc

Func Curl_Easy_Unescape($Handle, $String, $Encode = 1)
	Static $curl_easy_unescape = __Curl_RuntimeLoader("curl_easy_unescape")
	Local $Ret = DllCallAddress("ptr:cdecl", $curl_easy_unescape, "ptr", $Handle, "str", $String, "int", 0, "int*", 0)
	Local $Ptr = $Ret[0], $Len = $Ret[4]
	If $Len = 0 Then Return ""

	$Ret = __Curl_Peek("byte[" & $Len & "]", $Ptr)
	Curl_Free($Ptr)
	If $Encode < 1 Or $Encode > 4 Then $Encode = 1
	Return BinaryToString($Ret, $Encode)
EndFunc

; ============================================================================================================================
; Multi Interface Functions
; ============================================================================================================================

Func Curl_Multi_Add_Handle($Handle, $EzHandle)
	Static $curl_multi_add_handle = __Curl_RuntimeLoader("curl_multi_add_handle")
	Return DllCallAddress("int:cdecl", $curl_multi_add_handle, "ptr", $Handle, "ptr", $EzHandle)[0]
EndFunc

Func Curl_Multi_Cleanup($Handle)
	Static $curl_multi_cleanup = __Curl_RuntimeLoader("curl_multi_cleanup")
	Return DllCallAddress("int:cdecl", $curl_multi_cleanup, "ptr", $Handle)[0]
EndFunc

Func Curl_Multi_Info_Read($Handle, ByRef $MsgsInQueue)
	Static $curl_multi_info_read = __Curl_RuntimeLoader("curl_multi_info_read")
	Local $Ret = DllCallAddress("ptr:cdecl", $curl_multi_info_read, "ptr", $Handle, "int*", 0)
	$MsgsInQueue = $Ret[2]

	If $Ret[0] Then Return DllStructCreate($tagCURLMsg, $Ret[0])
	Return Null
EndFunc

Func Curl_Multi_Init()
	Static $curl_multi_init = __Curl_RuntimeLoader("curl_multi_init")
	Return DllCallAddress("ptr:cdecl", $curl_multi_init)[0]
EndFunc

Func Curl_Multi_Perform($Handle, ByRef $RunningHandles)
	Static $curl_multi_perform = __Curl_RuntimeLoader("curl_multi_perform")
	Local $Ret = DllCallAddress("int:cdecl", $curl_multi_perform, "ptr", $Handle, "int*", 0)
	$RunningHandles = $Ret[2]
	Return $Ret[0]
EndFunc

Func Curl_Multi_Remove_Handle($Handle, $EzHandle)
	Static $curl_multi_remove_handle = __Curl_RuntimeLoader("curl_multi_remove_handle")
	Return DllCallAddress("int:cdecl", $curl_multi_remove_handle, "ptr", $Handle, "ptr", $EzHandle)[0]
EndFunc

Func Curl_Multi_Setopt($Handle, $Option, $Value)
	Static $curl_multi_setopt = __Curl_RuntimeLoader("curl_multi_setopt")
	Return DllCallAddress("int:cdecl", $curl_multi_setopt, "ptr", $Handle, "int", $Option, IsString($Value) ? "str" : "ptr", $Value)[0]
EndFunc

Func Curl_Multi_StrError($ErrorNum)
	Static $curl_multi_strerror = __Curl_RuntimeLoader("curl_multi_strerror")
	Return DllCallAddress("str:cdecl", $curl_multi_strerror, "int", $ErrorNum)[0]
EndFunc

; ============================================================================================================================
; Public Help Functions
; ============================================================================================================================

Func Curl_DataWriteCallback()
	Static $Ptr = DllCallbackGetPtr(DllCallbackRegister(__Curl_DataWriteCallback, "uint_ptr:cdecl", "ptr;uint_ptr;uint_ptr;ptr"))
	Return $Ptr
EndFunc

Func Curl_DataReadCallback()
	Static $Ptr = DllCallbackGetPtr(DllCallbackRegister(__Curl_DataReadCallback, "uint_ptr:cdecl", "ptr;uint_ptr;uint_ptr;ptr"))
	Return $Ptr
EndFunc

Func Curl_FileWriteCallback()
	Static $Ptr = DllCallbackGetPtr(DllCallbackRegister(__Curl_FileWriteCallback, "uint_ptr:cdecl", "ptr;uint_ptr;uint_ptr;ptr"))
	Return $Ptr
EndFunc

Func Curl_FileReadCallback()
	Static $Ptr = DllCallbackGetPtr(DllCallbackRegister(__Curl_FileReadCallback, "uint_ptr:cdecl", "ptr;uint_ptr;uint_ptr;ptr"))
	Return $Ptr
EndFunc

Func Curl_Data_Put($Handle, $Data)
	Local $Dict = __Curl_RuntimeLoader("dict")
	__Curl_DictPut($Dict, Ptr($Handle), Binary($Data))
EndFunc

Func Curl_Data_Get($Handle)
	Local $Dict = __Curl_RuntimeLoader("dict")
	Return __Curl_DictGet($Dict, Ptr($Handle))
EndFunc

Func Curl_Data_Cleanup($Handle)
	Local $Dict = __Curl_RuntimeLoader("dict")
	__Curl_DictDelete($Dict, Ptr($Handle))
EndFunc

Func Curl_Slist_ToArray($List)
	Static $PtrSize = DllStructGetSize(DllStructCreate("ptr"))
	Local $Text = ''
	While $List
		Local $Ptr = __Curl_Peek("ptr", $List)
		Local $Line = __Curl_Peek("str", $Ptr)
		$List = __Curl_Peek("ptr", $List + $PtrSize)
		$Text &= $Line & ($List ? Chr(0) : "")
	WEnd
	Return StringSplit($Text, Chr(0), 3)
EndFunc
